/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.api;

import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profiler.CommonProfilerBundleKt;
import com.intellij.profiler.api.ValueMetric;
import com.intellij.profiler.ui.threadview.CallTreeValueBasedMetric;
import com.intellij.profiler.ui.threadview.ThreadMetric;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001dB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0015\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0015\u0010\u0019\u001a\u00070\u0005\u00a2\u0006\u0002\b\u001a2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u001c\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u001c2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u0014\u0010\n\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001e"}, d2={"Lcom/intellij/profiler/api/AllocationSizeMetric;", "Lcom/intellij/profiler/api/ValueMetric;", "<init>", "()V", "name", "", "getName", "()Ljava/lang/String;", "columnTitle", "getColumnTitle", "unit", "getUnit", "threadMetric", "Lcom/intellij/profiler/ui/threadview/ThreadMetric;", "", "getThreadMetric", "()Lcom/intellij/profiler/ui/threadview/ThreadMetric;", "hasFixedUnits", "", "getHasFixedUnits", "()Z", "formatUnit", "Lorg/jetbrains/annotations/Nls;", "value", "", "formatValue", "Lcom/intellij/openapi/util/NlsSafe;", "valueAndUnit", "Lkotlin/Pair;", "MyThreadMetric", "intellij.profiler.common"})
public final class AllocationSizeMetric
implements ValueMetric {
    @NotNull
    public static final AllocationSizeMetric INSTANCE = new AllocationSizeMetric();
    @NotNull
    private static final String unit = CommonProfilerBundleKt.profilerMessage("ui.metrics.alloc", new Object[0]);
    @NotNull
    private static final ThreadMetric<Float> threadMetric = MyThreadMetric.INSTANCE;

    private AllocationSizeMetric() {
    }

    @Override
    @NotNull
    public String getName() {
        return this.getHasFixedUnits() ? CommonProfilerBundleKt.profilerMessage("ui.metrics.alloc.name.unit", new Object[0]) : CommonProfilerBundleKt.profilerMessage("ui.metrics.alloc.name", new Object[0]);
    }

    @Override
    @NotNull
    public String getColumnTitle() {
        return this.getName();
    }

    @Override
    @NotNull
    public String getUnit() {
        return unit;
    }

    @Override
    @NotNull
    public ThreadMetric<Float> getThreadMetric() {
        return threadMetric;
    }

    @Override
    public boolean getHasFixedUnits() {
        return Registry.Companion.is("idea.profiler.allocations.in.bytes");
    }

    @Override
    @NotNull
    public String formatUnit(long value) {
        String string;
        if (this.getHasFixedUnits()) {
            Object[] objectArray = new Object[]{value};
            string = CommonProfilerBundleKt.profilerMessage("ui.metrics.alloc.options", objectArray);
        } else {
            string = (String)this.valueAndUnit(value).getSecond();
        }
        return string;
    }

    @Override
    @NotNull
    public String formatValue(long value) {
        return this.getHasFixedUnits() ? ValueMetric.super.formatValue(value) : (String)this.valueAndUnit(value).getFirst();
    }

    private final Pair<String, String> valueAndUnit(long value) {
        String string = StringUtil.formatFileSize((long)Math.abs(value), (String)" ");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"formatFileSize(...)");
        String[] stringArray = new String[]{" "};
        List list = StringsKt.split$default((CharSequence)string, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        String newValue = (String)list.get(0);
        String unit = (String)list.get(1);
        return TuplesKt.to((Object)(value < 0L ? "-" + newValue : newValue), (Object)unit);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001b\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00068\u0016X\u0097\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u000b"}, d2={"Lcom/intellij/profiler/api/AllocationSizeMetric$MyThreadMetric;", "Lcom/intellij/profiler/ui/threadview/CallTreeValueBasedMetric;", "<init>", "()V", "name", "", "Lorg/jetbrains/annotations/Nls;", "getName", "()Ljava/lang/String;", "persistentName", "getPersistentName", "intellij.profiler.common"})
    private static final class MyThreadMetric
    extends CallTreeValueBasedMetric {
        @NotNull
        public static final MyThreadMetric INSTANCE = new MyThreadMetric();
        @Nls
        @NotNull
        private static final String name = CommonProfilerBundleKt.profilerMessage("ui.threadlist.metrics.allocationSize", new Object[0]);
        @NotNull
        private static final String persistentName = "allocationSize";

        private MyThreadMetric() {
        }

        @Override
        @NotNull
        public String getName() {
            return name;
        }

        @Override
        @NotNull
        public String getPersistentName() {
            return persistentName;
        }
    }
}

