/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.liquibase.reference.provider;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.icons.AllIcons;
import com.intellij.jpa.jpb.model.complition.JpbLookupElements;
import com.intellij.jpa.jpb.model.util.EntityUtil;
import com.intellij.jpa.jpb.model.util.SUastUtils;
import com.intellij.liquibase.common.msg.LiquibaseResourceBundle;
import com.intellij.liquibase.reference.provider.LiquibaseReference;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B\u0019\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\n\u0010\u000b\u001a\u0004\u0018\u00010\u0006H\u0016J\u0013\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016\u00a2\u0006\u0002\u0010\u000fJ\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004H\u0002J\u0010\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0004H\u0016J\b\u0010\u0014\u001a\u00020\u0004H\u0016R\u0013\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lcom/intellij/liquibase/reference/provider/TableNameReference;", "Lcom/intellij/liquibase/reference/provider/LiquibaseReference;", "Lcom/intellij/codeInsight/daemon/EmptyResolveMessageProvider;", "tableName", "", "psiElement", "Lcom/intellij/psi/PsiElement;", "<init>", "(Ljava/lang/String;Lcom/intellij/psi/PsiElement;)V", "getTableName", "()Ljava/lang/String;", "resolve", "getVariants", "", "", "()[Ljava/lang/Object;", "createOption", "Lcom/intellij/codeInsight/lookup/LookupElement;", "handleElementRename", "newElementName", "getUnresolvedMessagePattern", "intellij.liquibase"})
@SourceDebugExtension(value={"SMAP\nTableNameReferenceProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TableNameReferenceProvider.kt\ncom/intellij/liquibase/reference/provider/TableNameReference\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,57:1\n136#2,9:58\n216#2:67\n217#2:69\n145#2:70\n1#3:68\n37#4,2:71\n*S KotlinDebug\n*F\n+ 1 TableNameReferenceProvider.kt\ncom/intellij/liquibase/reference/provider/TableNameReference\n*L\n37#1:58,9\n37#1:67\n37#1:69\n37#1:70\n37#1:68\n37#1:71,2\n*E\n"})
public class TableNameReference
extends LiquibaseReference
implements EmptyResolveMessageProvider {
    @Nullable
    private final String tableName;

    public TableNameReference(@Nullable String tableName, @NotNull PsiElement psiElement) {
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        super(psiElement);
        this.tableName = tableName;
    }

    @Nullable
    public final String getTableName() {
        return this.tableName;
    }

    @Nullable
    public PsiElement resolve() {
        try {
            CharSequence charSequence = this.tableName;
            if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                return null;
            }
            return this.getReferenceManager().findTableOwnerElementByTableName(this.tableName);
        }
        catch (Exception e) {
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Object[] getVariants() {
        void $this$mapNotNullTo$iv$iv;
        Map $this$mapNotNull$iv = this.getReferenceManager().getAllTables();
        boolean $i$f$mapNotNull = false;
        Map map = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            LookupElement it$iv$iv;
            Map.Entry element$iv$iv$iv;
            Map.Entry element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Map.Entry it = element$iv$iv;
            boolean bl2 = false;
            if (this.createOption((PsiElement)it.getValue(), (String)it.getKey()) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new Object[0]);
    }

    private final LookupElement createOption(PsiElement psiElement, String tableName) {
        PsiClass psiClass = SUastUtils.getContainingClass((PsiElement)psiElement);
        if (psiClass == null) {
            return null;
        }
        PsiClass psiClass2 = psiClass;
        String string = EntityUtil.getPackageName((PsiClass)psiClass2);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPackageName(...)");
        String packageName = string;
        Object[] objectArray = new String[]{tableName, psiClass2.getName()};
        return (LookupElement)JpbLookupElements.element((String)tableName, (String)packageName).withPsiElement((PsiElement)psiClass2).withIcon(AllIcons.Javaee.PersistenceEntity).withLookupStrings((Collection)CollectionsKt.listOf((Object[])objectArray)).withCaseSensitivity(false);
    }

    @NotNull
    public PsiElement handleElementRename(@NotNull String newElementName) {
        Intrinsics.checkNotNullParameter((Object)newElementName, (String)"newElementName");
        PsiElement psiElement = this.myElement;
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"myElement");
        return psiElement;
    }

    @NotNull
    public String getUnresolvedMessagePattern() {
        Object[] objectArray = new Object[]{this.tableName};
        String string = LiquibaseResourceBundle.message("inspection.message.unknown.table", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }
}

