/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent.devcontainers.feautures;

import com.intellij.docker.agent.devcontainers.feautures.DevcontainerResource;
import com.intellij.docker.agent.devcontainers.model.DevcontainerFeature;
import com.intellij.docker.agent.devcontainers.model.DevcontainerFeatureSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0000\u0018\u00002\u00020\u0001:\u0002\u0017\u0018B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0005J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00052\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u001c\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00052\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0005H\u0002J\u001c\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00052\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0005H\u0002J\u001c\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00052\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/docker/agent/devcontainers/feautures/DevcontainerFeatureOrderResolver;", "", "featureSet", "Lcom/intellij/docker/agent/devcontainers/model/DevcontainerFeatureSet;", "overrideFeatureInstallOrder", "", "", "<init>", "(Lcom/intellij/docker/agent/devcontainers/model/DevcontainerFeatureSet;Ljava/util/List;)V", "idToFeature", "", "Lcom/intellij/docker/agent/devcontainers/model/DevcontainerFeature;", "order", "getAllDependencies", "Lcom/intellij/docker/agent/devcontainers/feautures/DevcontainerResource$Ref;", "config", "Lcom/intellij/docker/agent/devcontainers/model/DevcontainerFeature$FeatureConfig;", "mergeWithStandalone", "features", "prioritizeOverriden", "byDependency", "resolveDependencies", "idList", "Graph", "CycleDetectionException", "intellij.clouds.docker.agent"})
@SourceDebugExtension(value={"SMAP\nDevcontainerFeatureOrderResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DevcontainerFeatureOrderResolver.kt\ncom/intellij/docker/agent/devcontainers/feautures/DevcontainerFeatureOrderResolver\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,103:1\n1869#2:104\n1869#2,2:105\n1870#2:107\n774#2:109\n865#2,2:110\n1563#2:112\n1634#2,3:113\n1617#2,9:116\n1869#2:125\n1870#2:127\n1626#2:128\n774#2:129\n865#2,2:130\n1869#2,2:132\n1#3:108\n1#3:126\n*S KotlinDebug\n*F\n+ 1 DevcontainerFeatureOrderResolver.kt\ncom/intellij/docker/agent/devcontainers/feautures/DevcontainerFeatureOrderResolver\n*L\n13#1:104\n16#1:105,2\n13#1:107\n36#1:109\n36#1:110,2\n44#1:112\n44#1:113,3\n46#1:116,9\n46#1:125\n46#1:127\n46#1:128\n47#1:129\n47#1:130,2\n54#1:132,2\n46#1:126\n*E\n"})
public final class DevcontainerFeatureOrderResolver {
    @NotNull
    private final DevcontainerFeatureSet featureSet;
    @NotNull
    private final List<String> overrideFeatureInstallOrder;
    @NotNull
    private final Map<String, DevcontainerFeature> idToFeature;

    public DevcontainerFeatureOrderResolver(@NotNull DevcontainerFeatureSet featureSet, @NotNull List<String> overrideFeatureInstallOrder) {
        Intrinsics.checkNotNullParameter((Object)featureSet, (String)"featureSet");
        Intrinsics.checkNotNullParameter(overrideFeatureInstallOrder, (String)"overrideFeatureInstallOrder");
        this.featureSet = featureSet;
        this.overrideFeatureInstallOrder = overrideFeatureInstallOrder;
        this.idToFeature = new LinkedHashMap();
    }

    @NotNull
    public final List<DevcontainerFeature> order() {
        Graph graph = new Graph();
        Iterable $this$forEach$iv = this.featureSet.getFeatures();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DevcontainerFeature it = (DevcontainerFeature)element$iv;
            boolean bl = false;
            String sourceId = it.getRef().getDependencyId();
            this.idToFeature.put(sourceId, it);
            Iterable $this$forEach$iv2 = this.getAllDependencies(it.getConfig());
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                DevcontainerResource.Ref target2 = (DevcontainerResource.Ref)element$iv2;
                boolean bl2 = false;
                String targetId = target2.getDependencyId();
                if (!this.idToFeature.containsKey(targetId)) {
                    Map<String, DevcontainerFeature> map2 = this.idToFeature;
                    Map<DevcontainerResource.Ref, DevcontainerFeature.FeatureConfig> map3 = it.getConfig().getDependsOn();
                    DevcontainerFeature devcontainerFeature = new DevcontainerFeature(target2, new DevcontainerFeature.FeatureConfig(target2.getId(), null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, map3 != null ? map3.containsKey(target2) : false, 0xFFFFFE, null), null, 4, null);
                    map2.put(targetId, devcontainerFeature);
                }
                graph.addEdge(sourceId, targetId);
            }
        }
        return this.mergeWithStandalone(this.prioritizeOverriden(this.resolveDependencies(CollectionsKt.reversed((Iterable)graph.topologicalSortWithCycleDetection()))));
    }

    private final List<DevcontainerResource.Ref> getAllDependencies(DevcontainerFeature.FeatureConfig config) {
        List list;
        block1: {
            Object it;
            List $this$getAllDependencies_u24lambda_u240 = list = (List)new ArrayList();
            boolean bl = false;
            List<DevcontainerResource.Ref> list2 = config.getInstallsAfter();
            if (list2 != null) {
                it = list2;
                boolean bl2 = false;
                $this$getAllDependencies_u24lambda_u240.addAll((Collection)it);
            }
            Map<DevcontainerResource.Ref, DevcontainerFeature.FeatureConfig> map2 = config.getDependsOn();
            if (map2 == null) break block1;
            it = map2;
            boolean bl3 = false;
            $this$getAllDependencies_u24lambda_u240.addAll(it.keySet());
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private final List<DevcontainerFeature> mergeWithStandalone(List<DevcontainerFeature> features) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        List result2;
        List $this$mergeWithStandalone_u24lambda_u240 = result2 = (List)new ArrayList();
        boolean bl = false;
        Iterable iterable = this.featureSet.getFeatures();
        List list = $this$mergeWithStandalone_u24lambda_u240;
        boolean $i$f$filter = false;
        void var8_8 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            DevcontainerFeature it = (DevcontainerFeature)element$iv$iv;
            boolean bl2 = false;
            if (!(!features.contains(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        list.addAll((List)destination$iv$iv);
        $this$mergeWithStandalone_u24lambda_u240.addAll((Collection)features);
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    private final List<DevcontainerFeature> prioritizeOverriden(List<DevcontainerFeature> byDependency) {
        void $this$filterTo$iv$iv;
        void $this$mapNotNullTo$iv$iv;
        void $this$mapTo$iv$iv;
        if (this.overrideFeatureInstallOrder.isEmpty()) {
            return byDependency;
        }
        Iterable $this$map$iv = this.overrideFeatureInstallOrder;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new DevcontainerResource.Ref((String)it).getDependencyId());
        }
        List overrideList = (List)destination$iv$iv;
        List result2 = new ArrayList();
        Collection collection = result2;
        Iterable $this$mapNotNull$iv = overrideList;
        boolean $i$f$mapNotNull = false;
        Iterable $i$f$mapTo22 = $this$mapNotNull$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        Iterable $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            DevcontainerFeature it$iv$iv;
            Object v0;
            block5: {
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                String ovrId = (String)element$iv$iv;
                boolean bl2 = false;
                Iterable iterable2 = byDependency;
                for (Object t : iterable2) {
                    DevcontainerFeature it = (DevcontainerFeature)t;
                    boolean bl3 = false;
                    if (!Intrinsics.areEqual((Object)it.getRef().getDependencyId(), (Object)ovrId)) continue;
                    v0 = t;
                    break block5;
                }
                v0 = null;
            }
            if ((DevcontainerFeature)v0 == null) continue;
            boolean bl = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        iterable = (List)destination$iv$iv2;
        CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
        collection = result2;
        Set overrideSet = CollectionsKt.toSet((Iterable)overrideList);
        boolean bl = false;
        Iterable $this$filter$iv = byDependency;
        boolean $i$f$filter = false;
        $this$forEach$iv$iv$iv = $this$filter$iv;
        Collection destination$iv$iv3 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            DevcontainerFeature it = (DevcontainerFeature)element$iv$iv;
            boolean bl4 = false;
            if (!(!overrideSet.contains(it.getRef().getDependencyId()))) continue;
            destination$iv$iv3.add(element$iv$iv);
        }
        iterable = (List)destination$iv$iv3;
        CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
        return result2;
    }

    private final List<DevcontainerFeature> resolveDependencies(List<String> idList) {
        List result2 = new ArrayList();
        Iterable $this$forEach$iv = idList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DevcontainerFeature it;
            String id2 = (String)element$iv;
            boolean bl = false;
            if (this.idToFeature.get(id2) == null) continue;
            boolean bl2 = false;
            if (!it.getConfig().isRequired()) continue;
            result2.add(it);
        }
        return result2;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/docker/agent/devcontainers/feautures/DevcontainerFeatureOrderResolver$CycleDetectionException;", "", "node", "", "<init>", "(Ljava/lang/String;)V", "getNode", "()Ljava/lang/String;", "intellij.clouds.docker.agent"})
    public static final class CycleDetectionException
    extends Throwable {
        @NotNull
        private final String node;

        public CycleDetectionException(@NotNull String node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            super(node);
            this.node = node;
        }

        @NotNull
        public final String getNode() {
            return this.node;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010!\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0006J\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\rR \u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/docker/agent/devcontainers/feautures/DevcontainerFeatureOrderResolver$Graph;", "", "<init>", "()V", "adjacencyList", "", "", "", "addEdge", "", "source", "destination", "topologicalSortWithCycleDetection", "", "intellij.clouds.docker.agent"})
    public static final class Graph {
        @NotNull
        private final Map<String, List<String>> adjacencyList = new LinkedHashMap();

        public final void addEdge(@NotNull String source, @NotNull String destination) {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
            this.adjacencyList.computeIfAbsent(source, arg_0 -> Graph.addEdge$lambda$1(Graph::addEdge$lambda$0, arg_0)).add(destination);
        }

        @NotNull
        public final List<String> topologicalSortWithCycleDetection() {
            Map visited = new LinkedHashMap();
            Map recursionStack = new LinkedHashMap();
            List topologicalOrder = new ArrayList();
            for (String node : this.adjacencyList.keySet()) {
                if (visited.getOrDefault(node, false).booleanValue()) continue;
                Graph.topologicalSortWithCycleDetection$checkCyclicAndAdd(visited, recursionStack, this, topologicalOrder, node);
            }
            CollectionsKt.reverse((List)topologicalOrder);
            return topologicalOrder;
        }

        private static final List addEdge$lambda$0(String it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return new ArrayList();
        }

        private static final List addEdge$lambda$1(Function1 $tmp0, Object p0) {
            return (List)$tmp0.invoke(p0);
        }

        private static final void topologicalSortWithCycleDetection$checkCyclicAndAdd(Map<String, Boolean> visited, Map<String, Boolean> recursionStack, Graph this$0, List<String> topologicalOrder, String node) {
            visited.put(node, true);
            recursionStack.put(node, true);
            List list = this$0.adjacencyList.get(node);
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            for (String neighbor : list) {
                if (!visited.getOrDefault(neighbor, false).booleanValue()) {
                    Graph.topologicalSortWithCycleDetection$checkCyclicAndAdd(visited, recursionStack, this$0, topologicalOrder, neighbor);
                    continue;
                }
                if (!recursionStack.getOrDefault(neighbor, false).booleanValue()) continue;
                throw new CycleDetectionException(node);
            }
            recursionStack.put(node, false);
            topologicalOrder.add(node);
        }
    }
}

