/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.debugger.Variable;
import org.jetbrains.debugger.VariableViewKt;
import org.jetbrains.debugger.values.ObjectValue;
import org.jetbrains.debugger.values.StringValue;
import org.jetbrains.debugger.values.Value;
import org.jetbrains.debugger.values.ValueType;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/debugger/CustomPropertiesValuePresentation;", "Lcom/intellij/xdebugger/frame/presentation/XValuePresentation;", "value", "Lorg/jetbrains/debugger/values/ObjectValue;", "properties", "", "Lorg/jetbrains/debugger/Variable;", "<init>", "(Lorg/jetbrains/debugger/values/ObjectValue;Ljava/util/List;)V", "renderValue", "", "renderer", "Lcom/intellij/xdebugger/frame/presentation/XValuePresentation$XValueTextRenderer;", "intellij.javascript.debugger.ui"})
public final class CustomPropertiesValuePresentation
extends XValuePresentation {
    @NotNull
    private final ObjectValue value;
    @NotNull
    private final List<Variable> properties;

    public CustomPropertiesValuePresentation(@NotNull ObjectValue value, @NotNull List<? extends Variable> properties) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter(properties, (String)"properties");
        this.value = value;
        this.properties = properties;
    }

    public void renderValue(@NotNull XValuePresentation.XValueTextRenderer renderer) {
        Intrinsics.checkNotNullParameter((Object)renderer, (String)"renderer");
        renderer.renderComment(VariableViewKt.getObjectValueDescription(this.value));
        renderer.renderSpecialSymbol(" {");
        boolean isFirst = true;
        block7: for (Variable property : this.properties) {
            Value value;
            if (isFirst) {
                isFirst = false;
            } else {
                renderer.renderSpecialSymbol(", ");
            }
            renderer.renderValue(property.getName(), DefaultLanguageHighlighterColors.INSTANCE_FIELD);
            renderer.renderSpecialSymbol(": ");
            Intrinsics.checkNotNull((Object)property.getValue());
            switch (WhenMappings.$EnumSwitchMapping$0[value.getType().ordinal()]) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    String string = value.getValueString();
                    Intrinsics.checkNotNull((Object)string);
                    renderer.renderKeywordValue(string);
                    continue block7;
                }
                case 5: 
                case 6: {
                    String string = value.getValueString();
                    Intrinsics.checkNotNull((Object)string);
                    renderer.renderNumericValue(string);
                    continue block7;
                }
                case 7: {
                    String string;
                    String string2 = string = value.getValueString();
                    Intrinsics.checkNotNull((Object)string2);
                    renderer.renderStringValue(string2, "\"\\", 1000);
                    StringValue stringValue = value instanceof StringValue ? (StringValue)value : null;
                    int actualStringLength = stringValue != null ? stringValue.getLength() : string.length();
                    if (actualStringLength <= 1000) continue block7;
                    Object[] objectArray = new Object[]{actualStringLength};
                    renderer.renderComment(XDebuggerBundle.message((String)"node.text.ellipsis.truncated", (Object[])objectArray));
                    continue block7;
                }
                case 8: {
                    renderer.renderComment(VariableViewKt.trimFunctionDescription(value));
                    continue block7;
                }
                case 9: {
                    renderer.renderComment(VariableViewKt.getObjectValueDescription((ObjectValue)value));
                    continue block7;
                }
            }
            String string = value.getValueString();
            Intrinsics.checkNotNull((Object)string);
            renderer.renderValue(string);
        }
        renderer.renderSpecialSymbol("}");
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ValueType.values().length];
            try {
                nArray[ValueType.BOOLEAN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ValueType.NULL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ValueType.UNDEFINED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ValueType.SYMBOL.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ValueType.NUMBER.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ValueType.BIGINT.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ValueType.STRING.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ValueType.FUNCTION.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ValueType.OBJECT.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

