/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mssql.inspections;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.connection.throwable.info.ErrorInfo;
import com.intellij.database.console.JdbcConsoleRunContext;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dataSource.DatabaseAuthProvider;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.DatabaseDriverClasspathManager;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.artifacts.DatabaseArtifactContext;
import com.intellij.database.dataSource.validation.DataSourceProblem;
import com.intellij.database.dataSource.validation.DatabaseConfigValidator;
import com.intellij.database.dataSource.validation.FixWithProgress;
import com.intellij.database.dialects.mssql.MsAzureAuthProviderBase;
import com.intellij.database.view.ui.ActualConfigInfoProvider;
import com.intellij.database.view.ui.DatabaseConfigEditor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MsAuthArtifactValidator
extends DatabaseConfigValidator<LocalDataSource> {
    public Class<? extends LocalDataSource> getTargetClass() {
        return LocalDataSource.class;
    }

    public void collectProblems(@NotNull Project project, @NotNull LocalDataSource target, @NotNull Consumer<? super DataSourceProblem> problems, @Nullable ActualConfigInfoProvider configInfoProvider) {
        MsAzureAuthProviderBase auth;
        if (project == null) {
            MsAuthArtifactValidator.$$$reportNull$$$0(0);
        }
        if (target == null) {
            MsAuthArtifactValidator.$$$reportNull$$$0(1);
        }
        if (problems == null) {
            MsAuthArtifactValidator.$$$reportNull$$$0(2);
        }
        if ((auth = (MsAzureAuthProviderBase)ObjectUtils.tryCast((Object)DatabaseAuthProvider.get((DatabaseConnectionPoint)target), MsAzureAuthProviderBase.class)) == null) {
            return;
        }
        MsAzureAuthProviderBase.RequiredArtifact requiredArtifact = auth.getRequiredArtifact(target);
        if (requiredArtifact == null) {
            return;
        }
        this.validateRequired(requiredArtifact, project, target, problems, DatabaseBundle.message((String)"notification.title.azure.active.directory.authentication", (Object[])new Object[0]));
    }

    public void validateRequired(@NotNull MsAzureAuthProviderBase.RequiredArtifact req, final @NotNull Project project, @NotNull LocalDataSource target, @NotNull Consumer<? super DataSourceProblem> problems, @NotNull @Nls String title) {
        DatabaseDriver driver;
        if (req == null) {
            MsAuthArtifactValidator.$$$reportNull$$$0(3);
        }
        if (project == null) {
            MsAuthArtifactValidator.$$$reportNull$$$0(4);
        }
        if (target == null) {
            MsAuthArtifactValidator.$$$reportNull$$$0(5);
        }
        if (problems == null) {
            MsAuthArtifactValidator.$$$reportNull$$$0(6);
        }
        if (title == null) {
            MsAuthArtifactValidator.$$$reportNull$$$0(7);
        }
        if ((driver = target.getDatabaseDriver()) != null && !this.usesArtifact(req, target, project)) {
            final ErrorInfo.Fix setUpFix = req.createSetUpFix(driver, false, DatabaseArtifactContext.Companion.getInstance(project, target));
            if (setUpFix == null) {
                return;
            }
            FixWithProgress fix = new FixWithProgress(this, setUpFix.getName()){

                public void run(@NotNull ProgressIndicator indicator, @Nullable DatabaseConfigEditor editor) {
                    if (indicator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    ApplicationManager.getApplication().invokeAndWait(() -> DataSourceUiUtil.applyFix((Project)project, (ErrorInfo.Fix)setUpFix, (DatabaseConfigEditor)editor));
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/dialects/mssql/inspections/MsAuthArtifactValidator$1", "run"));
                }
            };
            problems.consume((Object)new DataSourceProblem((Object)target, (Object)this, DataSourceProblem.Level.WARNING, new DataSourceProblem.HyperText(title, DatabaseBundle.message((String)"notification.content.extra.libraries.required.href.action0.download", (Object[])new Object[0]), DatabaseBundle.message((String)"notification.content.extra.libraries.required", (Object[])new Object[0]), new Object[]{fix}), fix));
        }
    }

    public boolean usesArtifact(@NotNull MsAzureAuthProviderBase.RequiredArtifact req, @NotNull LocalDataSource target, @NotNull Project project) {
        DatabaseDriver driver;
        if (req == null) {
            MsAuthArtifactValidator.$$$reportNull$$$0(8);
        }
        if (target == null) {
            MsAuthArtifactValidator.$$$reportNull$$$0(9);
        }
        if (project == null) {
            MsAuthArtifactValidator.$$$reportNull$$$0(10);
        }
        if ((driver = target.getDatabaseDriver()) == null) {
            return false;
        }
        if (this.usesArtifact(req, driver)) {
            return true;
        }
        DatabaseArtifactContext artifactContext = DatabaseArtifactContext.Companion.getInstance(project, target);
        return JdbcConsoleRunContext.expandPackUrls((List)DatabaseDriverClasspathManager.Companion.getInstance(project).getClasspathElements(driver, artifactContext), (DatabaseArtifactContext)DatabaseArtifactContext.Companion.getInstance(project, target)).find(arg_0 -> ((MsAzureAuthProviderBase.RequiredArtifact)req).checkFile(arg_0)) != null;
    }

    public boolean usesArtifact(@NotNull MsAzureAuthProviderBase.RequiredArtifact req, DatabaseDriver driver) {
        DatabaseDriver.ArtifactRef artifactRef;
        if (req == null) {
            MsAuthArtifactValidator.$$$reportNull$$$0(11);
        }
        return (artifactRef = MsAzureAuthProviderBase.RequiredArtifact.Companion.findArtifact(driver, req.getArtifactId())) != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problems";
                break;
            }
            case 3: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "req";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/dialects/mssql/inspections/MsAuthArtifactValidator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "collectProblems";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "validateRequired";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "usesArtifact";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

