/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.pom;

import com.intellij.jam.JamElement;
import com.intellij.jam.JamPomTarget;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.pom.PomTarget;
import com.intellij.pom.PomTargetPsiElement;
import com.intellij.psi.DelegatePsiTarget;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.targets.AliasingPsiTarget;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.spring.SpringLocalModelFactory;
import com.intellij.spring.contexts.model.LocalAnnotationModel;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringBeanPsiTarget;
import com.intellij.spring.model.jam.JamPsiMemberSpringBean;
import com.intellij.spring.model.jam.stereotype.SpringStereotypeElement;
import com.intellij.spring.model.jam.utils.SpringJamUtils;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UastContextKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0007J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\b\u001a\u00020\tH\u0007J\u0014\u0010\n\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000b2\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\f"}, d2={"Lcom/intellij/spring/model/pom/SpringBeanPomTargetUtils;", "", "<init>", "()V", "getSpringBean", "Lcom/intellij/spring/model/CommonSpringBean;", "element", "Lcom/intellij/psi/PsiElement;", "target", "Lcom/intellij/pom/PomTarget;", "findRegisteredBean", "Lcom/intellij/spring/model/SpringBeanPointer;", "intellij.spring"})
@SourceDebugExtension(value={"SMAP\nSpringBeanPomTargetUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpringBeanPomTargetUtils.kt\ncom/intellij/spring/model/pom/SpringBeanPomTargetUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,79:1\n1#2:80\n*E\n"})
public final class SpringBeanPomTargetUtils {
    @NotNull
    public static final SpringBeanPomTargetUtils INSTANCE = new SpringBeanPomTargetUtils();

    private SpringBeanPomTargetUtils() {
    }

    @JvmStatic
    @Nullable
    public static final CommonSpringBean getSpringBean(@Nullable PsiElement element) {
        if (!(element instanceof PomTargetPsiElement)) {
            return null;
        }
        PomTarget pomTarget = ((PomTargetPsiElement)element).getTarget();
        Intrinsics.checkNotNullExpressionValue((Object)pomTarget, (String)"getTarget(...)");
        PomTarget target = pomTarget;
        if (!target.isValid()) {
            return null;
        }
        return SpringBeanPomTargetUtils.getSpringBean(target);
    }

    @JvmStatic
    @Nullable
    public static final CommonSpringBean getSpringBean(@NotNull PomTarget target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        PomTarget pomTarget = target;
        if (pomTarget instanceof AliasingPsiTarget) {
            PsiElement psiElement = ((AliasingPsiTarget)target).getNavigationElement();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getNavigationElement(...)");
            PsiElement navigationElement = psiElement;
            UClass uClass = (UClass)UastContextKt.toUElement((PsiElement)navigationElement, UClass.class);
            if (uClass == null) {
                return null;
            }
            SpringStereotypeElement stereotypeElement = SpringJamUtils.getInstance().findStereotypeElement(uClass.getJavaPsi());
            if (stereotypeElement != null && stereotypeElement.getPsiTarget() instanceof AliasingPsiTarget) {
                return stereotypeElement;
            }
            return null;
        }
        if (pomTarget instanceof SpringBeanPsiTarget) {
            return ((SpringBeanPsiTarget)target).getSpringBean();
        }
        if (pomTarget instanceof JamPomTarget) {
            JamElement jamElement = ((JamPomTarget)target).getJamElement();
            if (jamElement instanceof JamPsiMemberSpringBean) {
                return (CommonSpringBean)jamElement;
            }
        } else if (pomTarget instanceof DelegatePsiTarget) {
            PsiElement psiElement = ((DelegatePsiTarget)target).getNavigationElement();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getNavigationElement(...)");
            SpringBeanPointer<?> springBeanPointer = INSTANCE.findRegisteredBean(psiElement);
            return springBeanPointer != null ? springBeanPointer.getSpringBean() : null;
        }
        return null;
    }

    @Nullable
    public final SpringBeanPointer<?> findRegisteredBean(@NotNull PsiElement element) {
        Object v5;
        block5: {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            if (!(element instanceof PsiCallExpression)) {
                return null;
            }
            PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class);
            if (psiClass == null) {
                return null;
            }
            PsiClass psiClass2 = psiClass;
            Module module = ModuleUtil.findModuleForPsiElement((PsiElement)element);
            if (module == null) {
                return null;
            }
            Module module2 = module;
            LocalAnnotationModel localAnnotationModel = SpringLocalModelFactory.getInstance().getOrCreateLocalAnnotationModel(psiClass2, module2, SetsKt.emptySet());
            if (localAnnotationModel == null) {
                return null;
            }
            LocalAnnotationModel model = localAnnotationModel;
            Collection<SpringBeanPointer<?>> collection = model.getLocalBeans();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"getLocalBeans(...)");
            Iterable iterable = collection;
            for (Object t : iterable) {
                SpringBeanPointer it = (SpringBeanPointer)t;
                boolean bl = false;
                PsiElement psiElement = it.getPsiElement();
                PomTargetPsiElement pomTargetPsiElement = psiElement instanceof PomTargetPsiElement ? (PomTargetPsiElement)psiElement : null;
                if (!Intrinsics.areEqual((Object)(pomTargetPsiElement != null ? pomTargetPsiElement.getNavigationElement() : null), (Object)element)) continue;
                v5 = t;
                break block5;
            }
            v5 = null;
        }
        return v5;
    }
}

