/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter.model;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapType;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.formatter.model.BlockRole;
import com.intellij.sql.formatter.model.BlockShape;
import com.intellij.sql.formatter.model.SqlBlock;
import com.intellij.sql.formatter.model.SqlBlockKt;
import com.intellij.sql.formatter.model.SqlCursorDefinitionBlock;
import com.intellij.sql.formatter.model.SqlFlowBlock;
import com.intellij.sql.formatter.model.SqlFormattingContext;
import com.intellij.sql.formatter.model.SqlFormattingFunKt;
import com.intellij.sql.formatter.model.SqlFormattingModelFun;
import com.intellij.sql.formatter.model.SqlNodeBlock;
import com.intellij.sql.formatter.model.SqlRangeBlock;
import com.intellij.sql.formatter.model.SqlTypeDefinitionBlock;
import com.intellij.sql.formatter.model.SqlVariableDefinitionBlock;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0014J\b\u0010\n\u001a\u00020\u000bH\u0014J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0005H\u0016J\b\u0010\u000f\u001a\u00020\tH\u0014J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0005H\u0016\u00a8\u0006\u0014"}, d2={"Lcom/intellij/sql/formatter/model/SqlDefinitionsSubsectionBlock;", "Lcom/intellij/sql/formatter/model/SqlRangeBlock;", "<init>", "()V", "makeBlock", "Lcom/intellij/sql/formatter/model/SqlBlock;", "node", "Lcom/intellij/lang/ASTNode;", "analyseOriginalCodeStyle", "", "userRequiresExpand", "", "defaultChildIndent", "Lcom/intellij/formatting/Indent;", "block", "configureFormattingAttributes", "decideSpacing", "Lcom/intellij/formatting/Spacing;", "block1", "block2", "intellij.database.sql.core.impl"})
@SourceDebugExtension(value={"SMAP\nSqlBlockStatementBlock.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlBlockStatementBlock.kt\ncom/intellij/sql/formatter/model/SqlDefinitionsSubsectionBlock\n+ 2 SqlBlock.kt\ncom/intellij/sql/formatter/model/SqlBlockKt\n+ 3 SqlBlock.kt\ncom/intellij/sql/formatter/model/SqlBlock\n*L\n1#1,387:1\n831#2,2:388\n945#2,2:390\n831#2,2:392\n111#3,5:394\n111#3,5:399\n*S KotlinDebug\n*F\n+ 1 SqlBlockStatementBlock.kt\ncom/intellij/sql/formatter/model/SqlDefinitionsSubsectionBlock\n*L\n289#1:388,2\n290#1:390,2\n291#1:392,2\n318#1:394,5\n331#1:399,5\n*E\n"})
public final class SqlDefinitionsSubsectionBlock
extends SqlRangeBlock {
    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public SqlBlock makeBlock(@NotNull ASTNode node) {
        SqlBlock sqlBlock;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        IElementType iElementType = node.getElementType();
        if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)SqlCompositeElementTypes.SQL_VARIABLE_DEFINITION))) {
            void parent$iv;
            void $this$withSetup$iv;
            SqlNodeBlock sqlNodeBlock = new SqlVariableDefinitionBlock();
            SqlBlock sqlBlock2 = this;
            ASTNode mainNode$iv = node;
            boolean $i$f$withSetup = false;
            $this$withSetup$iv.setup$intellij_database_sql_core_impl((SqlBlock)parent$iv, mainNode$iv);
            sqlBlock = SqlBlockKt.withRole((SqlBlock)$this$withSetup$iv, BlockRole.ELEMENT);
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)SqlCompositeElementTypes.SQL_CURSOR_DEFINITION))) {
            SqlRangeBlock $this$withSetup$iv = new SqlCursorDefinitionBlock();
            SqlBlock parent$iv = this;
            ASTNode outerNode$iv = node;
            boolean $i$f$withSetup = false;
            TextRange textRange = outerNode$iv.getTextRange();
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
            $this$withSetup$iv.setup$intellij_database_sql_core_impl(parent$iv, textRange, SqlFormattingModelFun.listChildren(outerNode$iv));
            sqlBlock = SqlBlockKt.withRole((SqlBlock)$this$withSetup$iv, BlockRole.ELEMENT);
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)((Object)SqlCompositeElementTypes.SQL_ALIAS_TYPE_DEFINITION)) || Intrinsics.areEqual((Object)iElementType, (Object)((Object)SqlCompositeElementTypes.SQL_TYPE_DEFINITION)) || Intrinsics.areEqual((Object)iElementType, (Object)((Object)SqlCompositeElementTypes.SQL_COLLECTION_TYPE_DEFINITION))) {
            void var3_5;
            SqlNodeBlock $this$withSetup$iv = new SqlTypeDefinitionBlock();
            SqlBlock parent$iv = this;
            ASTNode mainNode$iv = node;
            boolean $i$f$withSetup = false;
            $this$withSetup$iv.setup$intellij_database_sql_core_impl(parent$iv, mainNode$iv);
            sqlBlock = SqlBlockKt.withRole((SqlBlock)var3_5, BlockRole.ELEMENT);
        } else {
            sqlBlock = super.makeBlock(node);
        }
        return sqlBlock;
    }

    @Override
    protected void analyseOriginalCodeStyle() {
        if (this.getContext().getSql().IMP_DECLARE_EL_WRAP == 0 && this.getContext().textContains(this.getRange(), '\n')) {
            this.setShape(BlockShape.DECIDED_TO_MULTI_ROWS);
        }
    }

    @Override
    protected boolean userRequiresExpand() {
        return this.getContext().getSql().IMP_DECLARE_EL_WRAP == 1;
    }

    @Override
    @NotNull
    public Indent defaultChildIndent(@NotNull SqlBlock block) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        return SqlFormattingFunKt.getNONE_INDENT();
    }

    @Override
    protected void configureFormattingAttributes() {
        SqlCodeStyleSettings s = this.getContext().getSql();
        Wrap w = this.makeWrap$intellij_database_sql_core_impl(s.IMP_DECLARE_EL_WRAP, false);
        Alignment a = !s.IMP_DECLARE_CONTENT_WRAP ? SqlFormattingModelFun.makeLeftAlignment() : null;
        Wrap nw = SqlFlowBlock.makeWrap$default(this, WrapType.NONE, false, 2, null);
        Alignment innerA1 = s.IMP_DECLARE_ALIGN_TYPE ? SqlFormattingModelFun.makeLeftAlignmentBS() : null;
        Alignment innerA2 = s.IMP_DECLARE_ALIGN_EQ ? SqlFormattingModelFun.makeLeftAlignmentBS() : null;
        Alignment innerA3 = s.IMP_DECLARE_ALIGN_DEFAULT ? SqlFormattingModelFun.makeLeftAlignmentBS() : null;
        boolean alignContent = s.IMP_DECLARE_ALIGN_TYPE || s.IMP_DECLARE_ALIGN_EQ || s.IMP_DECLARE_ALIGN_DEFAULT;
        for (SqlBlock b : this.getNestedBlocks()) {
            switch (WhenMappings.$EnumSwitchMapping$0[b.getRole().ordinal()]) {
                case 4: {
                    Wrap wrap$iv;
                    Object $this$iv;
                    SqlBlock sqlBlock = b;
                    Wrap wrap = w;
                    Alignment align$iv = a;
                    Indent indent$iv = ((SqlBlock)$this$iv).getMyIndent();
                    boolean $i$f$setAttributes = false;
                    ((SqlBlock)$this$iv).setMyWrap(wrap$iv);
                    ((SqlBlock)$this$iv).setMyIndent(indent$iv);
                    ((SqlBlock)$this$iv).setMyAlign(align$iv);
                    if (!alignContent || !(b instanceof SqlVariableDefinitionBlock)) break;
                    $this$iv = ((SqlVariableDefinitionBlock)b).getNestedBlocks().iterator();
                    while ($this$iv.hasNext()) {
                        SqlBlock bb = (SqlBlock)$this$iv.next();
                        bb.setMyAlign(switch (WhenMappings.$EnumSwitchMapping$0[bb.getRole().ordinal()]) {
                            case 1 -> innerA1;
                            case 2 -> innerA2;
                            case 3 -> innerA3;
                            default -> null;
                        });
                    }
                    break;
                }
                case 5: {
                    Object $this$iv = b;
                    Wrap wrap$iv = nw;
                    Indent indent$iv = ((SqlBlock)$this$iv).getMyIndent();
                    Alignment align$iv = ((SqlBlock)$this$iv).getMyAlign();
                    boolean $i$f$setAttributes = false;
                    ((SqlBlock)$this$iv).setMyWrap(wrap$iv);
                    ((SqlBlock)$this$iv).setMyIndent(indent$iv);
                    ((SqlBlock)$this$iv).setMyAlign(align$iv);
                }
            }
        }
    }

    @Override
    @Nullable
    public Spacing decideSpacing(@NotNull SqlBlock block1, @NotNull SqlBlock block2) {
        Intrinsics.checkNotNullParameter((Object)block1, (String)"block1");
        Intrinsics.checkNotNullParameter((Object)block2, (String)"block2");
        if (block2.getRole() == BlockRole.ELEMENT) {
            int wrapSetting = this.getContext().getSql().IMP_DECLARE_EL_WRAP;
            boolean keepLB = wrapSetting == 0 || wrapSetting == 3;
            return SqlFormattingContext.makeSpace$default(this.getContext(), false, keepLB, 1, null);
        }
        return super.decideSpacing(block1, block2);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[BlockRole.values().length];
            try {
                nArray[BlockRole.TYPE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BlockRole.EQ.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BlockRole.AMENDMENT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BlockRole.ELEMENT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BlockRole.DELIMITER.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

