/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.jupyter.magics;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.jupyter.api.CodePreprocessor;
import org.jetbrains.kotlinx.jupyter.api.ExtensionsProcessor;
import org.jetbrains.kotlinx.jupyter.api.KotlinKernelHost;
import org.jetbrains.kotlinx.jupyter.exceptions.KernelInternalObject;
import org.jetbrains.kotlinx.jupyter.exceptions.LibraryProblemPart;
import org.jetbrains.kotlinx.jupyter.exceptions.ReplLibraryExceptionKt;
import org.jetbrains.kotlinx.jupyter.util.PriorityList;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00010\u0002B\u001b\u0012\u0012\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0004\"\u00020\u0001\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0001H\u0016J\b\u0010\u0014\u001a\u00020\u000fH\u0016J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00010\u0016H\u0016J\u001a\u0010\u0017\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00120\u00190\u0018H\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlinx/jupyter/magics/CompoundCodePreprocessor;", "Lorg/jetbrains/kotlinx/jupyter/api/CodePreprocessor;", "Lorg/jetbrains/kotlinx/jupyter/api/ExtensionsProcessor;", "preprocessors", "", "<init>", "([Lorg/jetbrains/kotlinx/jupyter/api/CodePreprocessor;)V", "Lorg/jetbrains/kotlinx/jupyter/util/PriorityList;", "process", "Lorg/jetbrains/kotlinx/jupyter/api/CodePreprocessor$Result;", "code", "", "host", "Lorg/jetbrains/kotlinx/jupyter/api/KotlinKernelHost;", "register", "", "extension", "priority", "", "unregister", "unregisterAll", "registeredExtensions", "", "registeredExtensionsWithPriority", "", "Lkotlin/Pair;", "shared-compiler"})
public final class CompoundCodePreprocessor
implements CodePreprocessor,
ExtensionsProcessor<CodePreprocessor> {
    @NotNull
    private final PriorityList<CodePreprocessor> preprocessors;

    public CompoundCodePreprocessor(CodePreprocessor ... preprocessors) {
        Intrinsics.checkNotNullParameter((Object)preprocessors, (String)"preprocessors");
        this.preprocessors = new PriorityList(false, 1, null);
        for (CodePreprocessor preprocessor : preprocessors) {
            this.register((Object)preprocessor);
        }
    }

    @Override
    @NotNull
    public CodePreprocessor.Result process(@NotNull String code, @NotNull KotlinKernelHost host2) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        Intrinsics.checkNotNullParameter((Object)host2, (String)"host");
        Ref.ObjectRef result2 = new Ref.ObjectRef();
        result2.element = new CodePreprocessor.Result(code, CollectionsKt.emptyList());
        for (CodePreprocessor preprocessor : this.preprocessors) {
            if (preprocessor instanceof KernelInternalObject) {
                CompoundCodePreprocessor.process$iteration((Ref.ObjectRef<CodePreprocessor.Result>)result2, host2, preprocessor);
                continue;
            }
            ReplLibraryExceptionKt.rethrowAsLibraryException(LibraryProblemPart.CODE_PREPROCESSORS, () -> CompoundCodePreprocessor.process$lambda$0(preprocessor, result2, host2));
        }
        return (CodePreprocessor.Result)result2.element;
    }

    @Override
    public void register(@NotNull CodePreprocessor extension, int priority) {
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        this.preprocessors.add(extension, priority);
    }

    @Override
    public void unregister(@NotNull CodePreprocessor extension) {
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        this.preprocessors.remove(extension);
    }

    @Override
    public void unregisterAll() {
        this.preprocessors.clear();
    }

    @Override
    @NotNull
    public Collection<CodePreprocessor> registeredExtensions() {
        return this.preprocessors.elements();
    }

    @Override
    @NotNull
    public List<Pair<CodePreprocessor, Integer>> registeredExtensionsWithPriority() {
        return this.preprocessors.elementsWithPriority();
    }

    private static final void process$iteration(Ref.ObjectRef<CodePreprocessor.Result> result2, KotlinKernelHost $host, CodePreprocessor preprocessor) {
        if (preprocessor.accepts(((CodePreprocessor.Result)result2.element).getCode())) {
            CodePreprocessor.Result newResult = preprocessor.process(((CodePreprocessor.Result)result2.element).getCode(), $host);
            result2.element = new CodePreprocessor.Result(newResult.getCode(), CollectionsKt.plus((Collection)((CodePreprocessor.Result)result2.element).getLibraries(), (Iterable)newResult.getLibraries()));
        }
    }

    private static final Unit process$lambda$0(CodePreprocessor $preprocessor, Ref.ObjectRef $result, KotlinKernelHost $host) {
        CompoundCodePreprocessor.process$iteration((Ref.ObjectRef<CodePreprocessor.Result>)$result, $host, $preprocessor);
        return Unit.INSTANCE;
    }
}

