/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dupLocator;

import com.intellij.dupLocator.DupInfo;
import com.intellij.dupLocator.DuplicatesProfile;
import com.intellij.dupLocator.DuplocateVisitor;
import com.intellij.dupLocator.DuplocatorSettings;
import com.intellij.dupLocator.DuplocatorState;
import com.intellij.dupLocator.JavaLightDuplicateProfileImplementation;
import com.intellij.dupLocator.LightDuplicateProfile;
import com.intellij.dupLocator.treeHash.FragmentsCollector;
import com.intellij.dupLocator.treeHash.JavaSpecificHasher;
import com.intellij.dupLocator.util.PsiFragment;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LighterAST;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JavaDuplicatesProfile
extends DuplicatesProfile
implements LightDuplicateProfile {
    private static final Logger LOG = Logger.getInstance(JavaDuplicatesProfile.class);
    private final JavaLanguage myLanguage = (JavaLanguage)Language.findInstance(JavaLanguage.class);
    private final LightDuplicateProfile myLightDuplicateProfile = new JavaLightDuplicateProfileImplementation();

    @NotNull
    public DuplocateVisitor createVisitor(@NotNull FragmentsCollector collector) {
        if (collector == null) {
            JavaDuplicatesProfile.$$$reportNull$$$0(0);
        }
        DuplocateVisitor duplocateVisitor = this.createVisitor(collector, false);
        if (duplocateVisitor == null) {
            JavaDuplicatesProfile.$$$reportNull$$$0(1);
        }
        return duplocateVisitor;
    }

    @NotNull
    public DuplocateVisitor createVisitor(@NotNull FragmentsCollector collector, boolean forIndexing) {
        if (collector == null) {
            JavaDuplicatesProfile.$$$reportNull$$$0(2);
        }
        return new JavaSpecificHasher(DuplocatorSettings.getInstance(), collector, forIndexing);
    }

    public boolean isMyLanguage(@NotNull Language language) {
        if (language == null) {
            JavaDuplicatesProfile.$$$reportNull$$$0(3);
        }
        return language == this.myLanguage;
    }

    @NotNull
    public DuplocatorState getDuplocatorState(@NotNull Language language) {
        if (language == null) {
            JavaDuplicatesProfile.$$$reportNull$$$0(4);
        }
        final DuplocatorSettings mySettings = DuplocatorSettings.getInstance();
        return new DuplocatorState(){

            public int getLowerBound() {
                return mySettings.LOWER_BOUND;
            }

            public int getDiscardCost() {
                return mySettings.DISCARD_COST;
            }
        };
    }

    @Nullable
    @Nls
    public String getComment(@NotNull DupInfo info, int index) {
        PsiFragment[] fragments;
        PsiFile psiFile;
        if (info == null) {
            JavaDuplicatesProfile.$$$reportNull$$$0(5);
        }
        return (psiFile = (fragments = info.getFragmentOccurences(index))[0].getFile()) instanceof PsiJavaFile ? ((PsiJavaFile)psiFile).getPackageName() : null;
    }

    public boolean shouldPutInIndex(PsiFragment fragment, int cost, DuplocatorState state) {
        PsiElement[] elements = fragment.getElements();
        if (elements.length == 0) {
            return false;
        }
        PsiElement element = elements[0];
        return JavaDuplicatesProfile.shouldPutInIndex(element);
    }

    private static boolean shouldPutInIndex(PsiElement element) {
        if (element instanceof PsiStatement) {
            PsiStatement lastStatement;
            PsiCodeBlock block;
            PsiStatement firstStatement;
            if (element instanceof PsiBlockStatement && (firstStatement = (PsiStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)(block = ((PsiBlockStatement)element).getCodeBlock()).getLBrace(), PsiStatement.class)) == (lastStatement = (PsiStatement)PsiTreeUtil.getPrevSiblingOfType((PsiElement)block.getRBrace(), PsiStatement.class)) && !JavaDuplicatesProfile.shouldPutInIndex((PsiElement)firstStatement)) {
                return false;
            }
            if (!(element instanceof PsiExpressionStatement || element instanceof PsiLabeledStatement || element instanceof PsiContinueStatement || element instanceof PsiEmptyStatement || element instanceof PsiBreakStatement || element instanceof PsiThrowStatement && ((PsiThrowStatement)element).getException() instanceof PsiReferenceExpression || element instanceof PsiReturnStatement || element instanceof PsiSwitchLabelStatement && ((PsiSwitchLabelStatement)element).isDefaultCase())) {
                return true;
            }
        }
        if (element instanceof PsiExpression && element.getParent() instanceof PsiExpressionStatement) {
            PsiReferenceExpression expression;
            ASTNode node;
            return !(element instanceof PsiMethodCallExpression ? (node = (expression = ((PsiMethodCallExpression)element).getMethodExpression()).getNode()).findChildByType(JavaTokenType.THIS_KEYWORD) != null || node.findChildByType(JavaTokenType.SUPER_KEYWORD) != null : element instanceof PsiAssignmentExpression);
        }
        return false;
    }

    public void process(@NotNull LighterAST ast, @NotNull LightDuplicateProfile.Callback callback) {
        if (ast == null) {
            JavaDuplicatesProfile.$$$reportNull$$$0(6);
        }
        if (callback == null) {
            JavaDuplicatesProfile.$$$reportNull$$$0(7);
        }
        this.myLightDuplicateProfile.process(ast, callback);
    }

    public boolean acceptsFile(@NotNull VirtualFile file) {
        if (file == null) {
            JavaDuplicatesProfile.$$$reportNull$$$0(8);
        }
        return this.myLightDuplicateProfile.acceptsFile(file);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collector";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/dupLocator/JavaDuplicatesProfile";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ast";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/dupLocator/JavaDuplicatesProfile";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createVisitor";
                break;
            }
            case 1: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isMyLanguage";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getDuplocatorState";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getComment";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "process";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "acceptsFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

