/*
 * Decompiled with CFR 0.152.
 */
package org.jrubyparser;

public class RegexpOptions
implements Cloneable {
    public static final RegexpOptions NULL_OPTIONS = new RegexpOptions(true);
    private boolean fixed;
    private boolean once;
    private boolean extended;
    private boolean multiline;
    private boolean ignorecase;
    private boolean java;
    private boolean encodingNone;
    private boolean kcodeDefault;
    private char kcodeChar;

    public RegexpOptions() {
        this(true);
    }

    public RegexpOptions(boolean isKCodeDefault) {
        this.kcodeDefault = isKCodeDefault;
    }

    public boolean isExtended() {
        return this.extended;
    }

    public void setExtended(boolean extended) {
        this.extended = extended;
    }

    public boolean isIgnorecase() {
        return this.ignorecase;
    }

    public void setIgnorecase(boolean ignorecase) {
        this.ignorecase = ignorecase;
    }

    public boolean isFixed() {
        return this.fixed;
    }

    public void setFixed(boolean fixed) {
        this.fixed = fixed;
    }

    public boolean isKcodeDefault() {
        return this.kcodeDefault;
    }

    public boolean isMultiline() {
        return this.multiline;
    }

    public void setMultiline(boolean multiline) {
        this.multiline = multiline;
    }

    public boolean isOnce() {
        return this.once;
    }

    public void setOnce(boolean once) {
        this.once = once;
    }

    public boolean isJava() {
        return this.java;
    }

    public void setJava(boolean java) {
        this.java = java;
    }

    public boolean isEncodingNone() {
        return this.encodingNone;
    }

    public void setEncodingNone(boolean encodingNone) {
        this.encodingNone = encodingNone;
    }

    public boolean isLiteral() {
        return this.multiline || this.ignorecase || this.extended || !this.isKcodeDefault();
    }

    public boolean isEmbeddable() {
        return this.multiline && this.ignorecase && this.extended;
    }

    public void setKCodeChar(char value) {
        this.kcodeChar = value;
    }

    public char getKCodeChar() {
        return this.kcodeChar;
    }

    public RegexpOptions withoutOnce() {
        RegexpOptions options = (RegexpOptions)this.clone();
        options.setOnce(false);
        return options;
    }

    public int hashCode() {
        int hash = 7;
        hash = 11 * hash + (this.fixed ? 1 : 0);
        hash = 11 * hash + (this.once ? 1 : 0);
        hash = 11 * hash + (this.extended ? 1 : 0);
        hash = 11 * hash + (this.multiline ? 1 : 0);
        hash = 11 * hash + (this.ignorecase ? 1 : 0);
        hash = 11 * hash + (this.java ? 1 : 0);
        hash = 11 * hash + (this.encodingNone ? 1 : 0);
        hash = 11 * hash + (this.kcodeDefault ? 1 : 0);
        return hash;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            throw new RuntimeException(cnse);
        }
    }

    public boolean equals(Object other) {
        if (!(other instanceof RegexpOptions)) {
            return false;
        }
        RegexpOptions o = (RegexpOptions)other;
        return o.encodingNone == this.encodingNone && o.extended == this.extended && o.fixed == this.fixed && o.ignorecase == this.ignorecase && o.java == this.java && o.kcodeDefault == this.kcodeDefault && o.multiline == this.multiline;
    }

    public String toString() {
        return "RegexpOptions(" + (this.encodingNone ? ", encodingNone" : "") + (this.extended ? ", extended" : "") + (this.fixed ? ", fixed" : "") + (this.ignorecase ? ", ignorecase" : "") + (this.java ? ", java" : "") + (this.kcodeDefault ? ", kcodeDefault" : "") + (this.multiline ? ", multiline" : "") + (this.once ? ", once" : "") + ")";
    }
}

