/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.server;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.execution.wsl.WslPath;
import com.intellij.javaee.oss.AppServersCommonBundle;
import com.intellij.javaee.oss.server.WslConfiguration;
import com.intellij.javaee.oss.server.WslSupportUtilKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.OSAgnosticPathUtil;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.InetAddress;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010$\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0007J\u0012\u0010\n\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0007J$\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\t0\f2\u0006\u0010\r\u001a\u00020\t2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\fH\u0007J\u001c\u0010\u000f\u001a\u0004\u0018\u00010\t2\u0006\u0010\r\u001a\u00020\t2\b\u0010\u0010\u001a\u0004\u0018\u00010\tH\u0007J\u0014\u0010\u0011\u001a\u0004\u0018\u00010\t2\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0007J\u0018\u0010\u0012\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\tH\u0007J\u0018\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\tH\u0007J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\t2\u0006\u0010\r\u001a\u00020\tH\u0007J\u001c\u0010\u0017\u001a\u0004\u0018\u00010\t2\u0006\u0010\r\u001a\u00020\t2\b\u0010\u0018\u001a\u0004\u0018\u00010\tH\u0002J\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\r\u001a\u00020\tJ\u001e\u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\f2\u0006\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\tJ\u0010\u0010\u001e\u001a\u0004\u0018\u00010\t2\u0006\u0010\u001f\u001a\u00020\tJ\u0012\u0010 \u001a\u0004\u0018\u00010\t2\u0006\u0010\u001c\u001a\u00020\u001aH\u0002J0\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\"2\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0$2\u0006\u0010\r\u001a\u00020\tH\u0007J,\u0010%\u001a\u00020&2\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0$2\u0006\u0010'\u001a\u00020\t2\u0006\u0010(\u001a\u00020\tH\u0002J\u0016\u0010)\u001a\u00020\t2\u0006\u0010*\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u001aJ\u001e\u0010+\u001a\b\u0012\u0004\u0012\u00020\t0,2\u0006\u0010\u001f\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u001aH\u0002J\u0010\u0010-\u001a\u00020\u00072\u0006\u0010.\u001a\u00020\tH\u0002J\u001a\u0010/\u001a\u0004\u0018\u00010\t2\u0006\u0010\r\u001a\u00020\t2\u0006\u00100\u001a\u00020\tH\u0002J\u0012\u00101\u001a\u0004\u0018\u00010\t2\u0006\u0010\u001c\u001a\u00020\u001aH\u0002J\u0016\u00102\u001a\b\u0012\u0004\u0012\u00020\t0\f2\u0006\u00103\u001a\u000204H\u0002J\u0010\u00105\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lcom/intellij/javaee/oss/server/WslSupportUtil;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "isWslPath", "", "path", "", "isUnderHomeDir", "toWslJavaOpts", "", "wslPath", "opts", "patchJavaOpts", "optString", "fromWslToLinuxPath", "fromWinToLinuxMntPath", "winPath", "fixPathForAppServer", "appServerPath", "getWslDistributionName", "toWslJavaOpt", "opt", "getWslConfiguration", "Lcom/intellij/javaee/oss/server/WslConfiguration;", "executeOnWsl", "wslConfiguration", "cmd", "getWslJavaHome", "serverHome", "getJavaHomeFromJavaExec", "patchWslJavaHome", "", "envVariables", "", "patchJavaEnv", "", "key", "defaultWslJava", "fromLinuxToWslPath", "linuxPath", "getJavaHomeLocations", "Lkotlin/sequences/Sequence;", "isJavaHomeVariable", "line", "getWinDriveMountPoint", "winDrive", "getWslUser", "readOutput", "inputStream", "Ljava/io/InputStream;", "isWinPath", "intellij.javaee.appServers"})
@SourceDebugExtension(value={"SMAP\nWslSupportUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WslSupportUtil.kt\ncom/intellij/javaee/oss/server/WslSupportUtil\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,263:1\n1617#2,9:264\n1869#2:273\n1870#2:275\n1626#2:276\n774#2:277\n865#2,2:278\n295#2,2:281\n1#3:274\n1#3:280\n13#4:283\n*S KotlinDebug\n*F\n+ 1 WslSupportUtil.kt\ncom/intellij/javaee/oss/server/WslSupportUtil\n*L\n36#1:264,9\n36#1:273\n36#1:275\n36#1:276\n43#1:277\n43#1:278,2\n138#1:281,2\n36#1:274\n22#1:283\n*E\n"})
public final class WslSupportUtil {
    @NotNull
    public static final WslSupportUtil INSTANCE = new WslSupportUtil();
    @NotNull
    private static final Logger LOG;

    private WslSupportUtil() {
    }

    @JvmStatic
    public static final boolean isWslPath(@Nullable String path) {
        return path != null && WslPath.Companion.isWslUncPath(path);
    }

    @JvmStatic
    public static final boolean isUnderHomeDir(@Nullable String path) {
        String string = WslSupportUtil.fromWslToLinuxPath(path);
        if (string == null) {
            string = "";
        }
        return StringsKt.startsWith$default((String)string, (String)"/home/", (boolean)false, (int)2, null);
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final List<String> toWslJavaOpts(@NotNull String wslPath, @NotNull List<String> opts) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)wslPath, (String)"wslPath");
        Intrinsics.checkNotNullParameter(opts, (String)"opts");
        Iterable $this$mapNotNull$iv = opts;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            if (INSTANCE.toWslJavaOpt(wslPath, it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @Nullable
    public static final String patchJavaOpts(@NotNull String wslPath, @Nullable String optString) {
        Collection destination$iv$iv;
        Object object;
        Intrinsics.checkNotNullParameter((Object)wslPath, (String)"wslPath");
        Object object2 = optString;
        if (object2 != null && (object2 = StringsKt.split$default((CharSequence)((CharSequence)object2), (char[])(object = (Object)new char[]{' '}), (boolean)false, (int)0, (int)6, null)) != null) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = (Iterable)object2;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl = false;
                boolean bl2 = ((CharSequence)it).length() > 0;
                if (!bl2) continue;
                destination$iv$iv.add(element$iv$iv);
            }
        } else {
            return null;
        }
        List opts = (List)destination$iv$iv;
        StringBuilder sb = new StringBuilder();
        object = ((Iterable)opts).iterator();
        int n = 0;
        while (object.hasNext()) {
            int index = n++;
            String opt = (String)object.next();
            if (StringsKt.startsWith$default((String)opt, (String)"-agentlib", (boolean)false, (int)2, null)) {
                String string = InetAddress.getLocalHost().getHostAddress();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getHostAddress(...)");
                v3 = sb.append(StringsKt.replace$default((String)opt, (String)"127.0.0.1", (String)string, (boolean)false, (int)4, null));
            } else if (StringsKt.startsWith$default((String)opt, (String)"-javaagent", (boolean)false, (int)2, null)) {
                String agentPath = StringsKt.substringAfter$default((String)opt, (char)':', null, (int)2, null);
                v3 = sb.append("-javaagent:" + WslSupportUtil.fromWinToLinuxMntPath(wslPath, agentPath));
            } else {
                v3 = sb.append(opt);
            }
            if (index + 1 >= opts.size()) continue;
            sb.append(' ');
        }
        return sb.toString();
    }

    @JvmStatic
    @Nullable
    public static final String fromWslToLinuxPath(@Nullable String path) {
        Object object;
        block3: {
            block2: {
                object = path;
                if (object == null) break block2;
                String string = object;
                Regex regex = WslSupportUtilKt.access$getWSL_REGEX$p();
                CharSequence p0 = string;
                boolean bl = false;
                MatchResult matchResult = regex.matchEntire(p0);
                object = matchResult;
                if (matchResult != null && (object = object.getGroupValues()) != null && (object = (String)object.get(1)) != null) break block3;
            }
            return null;
        }
        Object wslPrefix = object;
        String p0 = StringsKt.replace$default((String)path, (String)wslPrefix, (String)"", (boolean)false, (int)4, null);
        boolean bl = false;
        return FileUtil.toSystemIndependentName((String)p0);
    }

    @JvmStatic
    @NotNull
    public static final String fromWinToLinuxMntPath(@NotNull String wslPath, @NotNull String winPath) {
        Intrinsics.checkNotNullParameter((Object)wslPath, (String)"wslPath");
        Intrinsics.checkNotNullParameter((Object)winPath, (String)"winPath");
        String winDrive = StringsKt.substringBefore$default((String)winPath, (char)'\\', null, (int)2, null);
        String winDrivePoint = INSTANCE.getWinDriveMountPoint(wslPath, winDrive);
        Object[] objectArray = (Object[])winDrivePoint;
        if (objectArray == null || objectArray.length() == 0) {
            LOG.warn("Failed to find Windows drive mount point by path: " + winPath);
            objectArray = new Object[]{winPath};
            throw new ExecutionException(AppServersCommonBundle.message("wsl.cant.find.win.drive.mount.point", objectArray));
        }
        String string = FileUtil.toSystemIndependentName((String)winPath);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toSystemIndependentName(...)");
        return StringsKt.replace$default((String)string, (String)winDrive, (String)winDrivePoint, (boolean)false, (int)4, null);
    }

    @JvmStatic
    @NotNull
    public static final String fixPathForAppServer(@NotNull String appServerPath, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)appServerPath, (String)"appServerPath");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (!WslSupportUtil.isWslPath(appServerPath)) {
            return path;
        }
        if (WslSupportUtil.isWslPath(path)) {
            String string = WslSupportUtil.fromWslToLinuxPath(path);
            if (string == null) {
                string = path;
            }
            return string;
        }
        return WslSupportUtil.fromWinToLinuxMntPath(appServerPath, path);
    }

    @JvmStatic
    @Nullable
    public static final String getWslDistributionName(@NotNull String wslPath) {
        Intrinsics.checkNotNullParameter((Object)wslPath, (String)"wslPath");
        Object object = WslSupportUtilKt.access$getWSL_REGEX$p().matchEntire((CharSequence)wslPath);
        return object != null && (object = object.getGroupValues()) != null ? (String)object.get(2) : null;
    }

    private final String toWslJavaOpt(String wslPath, String opt) {
        String[] stringArray;
        Object object = opt;
        if (object == null || (object = StringsKt.split$default((CharSequence)((CharSequence)object), (String[])(stringArray = new String[]{"="}), (boolean)false, (int)0, (int)6, null)) == null) {
            return null;
        }
        Object object2 = object;
        String key = (String)object2.get(0);
        String value = (String)object2.get(1);
        return this.isWinPath(value) ? key + "=" + WslSupportUtil.fromWinToLinuxMntPath(wslPath, value) : opt;
    }

    @Nullable
    public final WslConfiguration getWslConfiguration(@NotNull String wslPath) {
        Object v0;
        Object object;
        block4: {
            Intrinsics.checkNotNullParameter((Object)wslPath, (String)"wslPath");
            object = WslSupportUtilKt.access$getWSL_PREFIXES$p();
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                Object t = iterator.next();
                String p0 = (String)t;
                boolean bl = false;
                if (!StringsKt.startsWith$default((String)wslPath, (String)p0, (boolean)false, (int)2, null)) continue;
                v0 = t;
                break block4;
            }
            v0 = null;
        }
        String string = v0;
        if (string == null) {
            return null;
        }
        String wslPrefix = string;
        Path path = WSLDistribution.findWslExe();
        String wslExePath = path != null ? ((Object)path).toString() : null;
        CharSequence charSequence = wslExePath;
        if (charSequence == null || charSequence.length() == 0) {
            LOG.warn("Unable to find WSL executable");
            return null;
        }
        String wslDistribution = WslSupportUtil.getWslDistributionName(wslPath);
        object = wslDistribution;
        if (object == null || object.length() == 0) {
            LOG.warn("Failed to determine WSL distribution for the given path: " + wslPath);
            return null;
        }
        return new WslConfiguration(wslExePath, wslDistribution, wslPrefix);
    }

    @Nullable
    public final List<String> executeOnWsl(@NotNull WslConfiguration wslConfiguration, @NotNull String cmd) {
        Intrinsics.checkNotNullParameter((Object)wslConfiguration, (String)"wslConfiguration");
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        String wslExePath = wslConfiguration.component1();
        String wslDistribution = wslConfiguration.component2();
        Process process = Runtime.getRuntime().exec(wslExePath + " -d " + wslDistribution + " --exec /bin/sh -c \"" + cmd + "\"");
        InputStream inputStream = process.getInputStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
        List<String> output = this.readOutput(inputStream);
        InputStream inputStream2 = process.getErrorStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream2, (String)"getErrorStream(...)");
        List<String> errorOutput = this.readOutput(inputStream2);
        if (!((Collection)errorOutput).isEmpty()) {
            LOG.warn("Failed to execute a command on WSL: " + cmd + ". An error occurred: " + CollectionsKt.firstOrNull(errorOutput));
            return null;
        }
        return output;
    }

    @Nullable
    public final String getWslJavaHome(@NotNull String serverHome) {
        Intrinsics.checkNotNullParameter((Object)serverHome, (String)"serverHome");
        WslConfiguration wslConfiguration = this.getWslConfiguration(serverHome);
        if (wslConfiguration == null) {
            return null;
        }
        WslConfiguration wslConfiguration2 = wslConfiguration;
        String string = (String)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull(this.getJavaHomeLocations(serverHome, wslConfiguration2), arg_0 -> WslSupportUtil.getWslJavaHome$lambda$0(wslConfiguration2, arg_0)));
        if (string == null) {
            string = this.getJavaHomeFromJavaExec(wslConfiguration2);
        }
        return string;
    }

    private final String getJavaHomeFromJavaExec(WslConfiguration wslConfiguration) {
        String string;
        String string2;
        String string3;
        List<String> list = this.executeOnWsl(wslConfiguration, "java -XshowSettings:properties -version 2>&1 > /dev/null | grep 'java.home'");
        if (list != null && (string3 = (String)CollectionsKt.firstOrNull(list)) != null && (string2 = StringsKt.substringAfter$default((String)string3, (String)"=", null, (int)2, null)) != null) {
            char[] cArray = new char[]{'\"', '\''};
            string = StringsKt.trim((String)string2, (char[])cArray);
        } else {
            string = null;
        }
        return string;
    }

    @JvmStatic
    @NotNull
    public static final Map<String, String> patchWslJavaHome(@NotNull Map<String, String> envVariables, @NotNull String wslPath) {
        Intrinsics.checkNotNullParameter(envVariables, (String)"envVariables");
        Intrinsics.checkNotNullParameter((Object)wslPath, (String)"wslPath");
        String wslJavaHome = INSTANCE.getWslJavaHome(wslPath);
        CharSequence charSequence = wslJavaHome;
        if (charSequence == null || charSequence.length() == 0) {
            LOG.warn("Unable to find JAVA_HOME declaration in WSL distribution");
            throw new ExecutionException(AppServersCommonBundle.message("wsl.java.home.detection.error", new Object[0]));
        }
        Map wslEnvVariables = MapsKt.toMutableMap(envVariables);
        INSTANCE.patchJavaEnv(wslEnvVariables, "JAVA_HOME", wslJavaHome);
        INSTANCE.patchJavaEnv(wslEnvVariables, "JRE_HOME", wslJavaHome);
        return wslEnvVariables;
    }

    private final void patchJavaEnv(Map<String, String> envVariables, String key, String defaultWslJava) {
        block2: {
            String string = envVariables.get(key);
            if (string == null) break block2;
            String it = string;
            boolean bl = false;
            envVariables.put(key, defaultWslJava);
            if (WslSupportUtil.isWslPath(it)) {
                String string2 = WslSupportUtil.fromWslToLinuxPath(it);
                if (string2 != null) {
                    String it2 = string2;
                    boolean bl2 = false;
                    envVariables.put(key, it2);
                }
            }
        }
    }

    @NotNull
    public final String fromLinuxToWslPath(@NotNull String linuxPath, @NotNull WslConfiguration wslConfiguration) {
        Intrinsics.checkNotNullParameter((Object)linuxPath, (String)"linuxPath");
        Intrinsics.checkNotNullParameter((Object)wslConfiguration, (String)"wslConfiguration");
        Object object = new char[]{'/', '\\'};
        String path = StringsKt.replace$default((String)StringsKt.trimStart((String)linuxPath, (char[])object), (char)'/', (char)'\\', (boolean)false, (int)4, null);
        char[] $this$fromLinuxToWslPath_u24lambda_u240 = object = (Object)new StringBuilder();
        boolean bl = false;
        $this$fromLinuxToWslPath_u24lambda_u240.append(wslConfiguration.getWslPrefix());
        $this$fromLinuxToWslPath_u24lambda_u240.append("\\");
        $this$fromLinuxToWslPath_u24lambda_u240.append(wslConfiguration.getDistribution());
        $this$fromLinuxToWslPath_u24lambda_u240.append("\\");
        $this$fromLinuxToWslPath_u24lambda_u240.append(path);
        return object.toString();
    }

    private final Sequence<String> getJavaHomeLocations(String serverHome, WslConfiguration wslConfiguration) {
        return SequencesKt.sequence((Function2)((Function2)new Function2<SequenceScope<? super String>, Continuation<? super Unit>, Object>(serverHome, wslConfiguration, null){
            Object L$1;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ String $serverHome;
            final /* synthetic */ WslConfiguration $wslConfiguration;
            {
                this.$serverHome = $serverHome;
                this.$wslConfiguration = $wslConfiguration;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = (SequenceScope)this.L$0;
                var5_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = WslSupportUtil.fromWslToLinuxPath(this.$serverHome);
                        if (v0 != null) {
                            var4_4 /* !! */  = new char[]{'/'};
                            v1 = StringsKt.trimEnd((String)v0, (char[])var4_4 /* !! */ );
                        } else {
                            v1 = null;
                        }
                        this.L$0 = $this$sequence;
                        this.label = 1;
                        v2 = $this$sequence.yield((Object)(v1 + "/bin/setenv.sh"), (Continuation)this);
                        if (v2 == var5_3) {
                            return var5_3;
                        }
                        ** GOTO lbl21
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
lbl21:
                        // 2 sources

                        if ((var4_4 /* !! */  = (char[])(wslUser = WslSupportUtil.access$getWslUser(WslSupportUtil.INSTANCE, this.$wslConfiguration))) == null || var4_4 /* !! */ .length() == 0) ** GOTO lbl44
                        this.L$0 = $this$sequence;
                        this.L$1 = wslUser;
                        this.label = 2;
                        v3 = $this$sequence.yield((Object)("/home/" + wslUser + "/.bashrc"), (Continuation)this);
                        if (v3 == var5_3) {
                            return var5_3;
                        }
                        ** GOTO lbl33
                    }
                    case 2: {
                        wslUser = (String)this.L$1;
                        ResultKt.throwOnFailure((Object)$result);
                        v3 = $result;
lbl33:
                        // 2 sources

                        this.L$0 = $this$sequence;
                        this.L$1 = SpillingKt.nullOutSpilledVariable((Object)wslUser);
                        this.label = 3;
                        v4 = $this$sequence.yield((Object)("/home/" + wslUser + "/.zshrc"), (Continuation)this);
                        if (v4 == var5_3) {
                            return var5_3;
                        }
                        ** GOTO lbl44
                    }
                    case 3: {
                        wslUser = (String)this.L$1;
                        ResultKt.throwOnFailure((Object)$result);
                        v4 = $result;
lbl44:
                        // 3 sources

                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$sequence);
                        this.L$1 = SpillingKt.nullOutSpilledVariable((Object)wslUser);
                        this.label = 4;
                        v5 = $this$sequence.yield((Object)"/etc/environment", (Continuation)this);
                        if (v5 == var5_3) {
                            return var5_3;
                        }
                        ** GOTO lbl55
                    }
                    case 4: {
                        wslUser = (String)this.L$1;
                        ResultKt.throwOnFailure((Object)$result);
                        v5 = $result;
lbl55:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(SequenceScope<? super String> p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    private final boolean isJavaHomeVariable(String line) {
        return !StringsKt.startsWith$default((String)line, (String)"#", (boolean)false, (int)2, null) && (StringsKt.contains$default((CharSequence)line, (CharSequence)"JAVA_HOME", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)line, (CharSequence)"JRE_HOME", (boolean)false, (int)2, null));
    }

    private final String getWinDriveMountPoint(String wslPath, String winDrive) {
        char[] cArray;
        List list;
        String string;
        WslConfiguration wslConfiguration = this.getWslConfiguration(wslPath);
        if (wslConfiguration == null) {
            return null;
        }
        WslConfiguration wslConfiguration2 = wslConfiguration;
        List<String> list2 = this.executeOnWsl(wslConfiguration2, "cat /proc/mounts | grep " + winDrive);
        return list2 != null && (string = (String)CollectionsKt.firstOrNull(list2)) != null && (list = StringsKt.split$default((CharSequence)string, (char[])(cArray = new char[]{' '}), (boolean)false, (int)0, (int)6, null)) != null ? (String)CollectionsKt.getOrNull((List)list, (int)1) : null;
    }

    private final String getWslUser(WslConfiguration wslConfiguration) {
        List<String> list = this.executeOnWsl(wslConfiguration, "whoami");
        return list != null ? (String)CollectionsKt.firstOrNull(list) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<String> readOutput(InputStream inputStream) {
        List list;
        Closeable closeable = inputStream;
        Throwable throwable = null;
        try {
            InputStream it = (InputStream)closeable;
            boolean bl = false;
            InputStream inputStream2 = it;
            Charset charset = Charsets.UTF_8;
            Reader reader = new InputStreamReader(inputStream2, charset);
            int n = 8192;
            list = SequencesKt.toList((Sequence)TextStreamsKt.lineSequence((BufferedReader)(reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n))));
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return list;
    }

    private final boolean isWinPath(String path) {
        return StringsKt.contains$default((CharSequence)path, (CharSequence)"\\", (boolean)false, (int)2, null) || OSAgnosticPathUtil.startsWithWindowsDrive((String)path);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final String getWslJavaHome$lambda$0(WslConfiguration $wslConfiguration, String location) {
        Object v0;
        Object object;
        Object object2;
        block1: {
            void $this$firstOrNull$iv;
            Intrinsics.checkNotNullParameter((Object)location, (String)"location");
            List<String> list = INSTANCE.executeOnWsl($wslConfiguration, "cat " + location);
            if (list == null) return null;
            object2 = list;
            object = INSTANCE;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                String p0 = (String)element$iv;
                boolean bl = false;
                if (!((WslSupportUtil)object).isJavaHomeVariable(p0)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        String string = v0;
        if (string == null) return null;
        object2 = StringsKt.substringAfter$default((String)string, (String)"=", null, (int)2, null);
        if (object2 == null) return null;
        object = new char[2];
        object[0] = 34;
        object[1] = 39;
        String string2 = StringsKt.trim((String)object2, (char[])object);
        return string2;
    }

    public static final /* synthetic */ String access$getWslUser(WslSupportUtil $this, WslConfiguration wslConfiguration) {
        return $this.getWslUser(wslConfiguration);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(WslSupportUtil.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

