/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.model;

import com.google.common.base.Preconditions;
import com.intellij.jpa.jpb.model.model.OrderBySource;
import com.intellij.jpa.jpb.model.model.Part;
import com.intellij.jpa.jpb.model.repository.PropertyReferenceException;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public class PartTree {
    private static final String KEYWORD_TEMPLATE = "(%s)(?=(\\p{Lu}|\\P{InBASIC_LATIN}))";
    public static final String QUERY_PATTERN = "find|read|get|query|search|stream";
    private static final String COUNT_PATTERN = "count";
    private static final String EXISTS_PATTERN = "exists";
    private static final String DELETE_PATTERN = "delete|remove";
    private static final String UPDATE_PATTERN = "update";
    public static final Pattern PREFIX_TEMPLATE = Pattern.compile("^(find|read|get|query|search|stream|count|exists|delete|remove|update)(\\p{Lu}.*?)??(By(.*)|$)");
    private final Subject subject;
    private final Predicate predicate;
    private final String methodPrefix;

    public PartTree(String source2) {
        Preconditions.checkNotNull((Object)source2, (Object)"Source must not be null");
        Matcher matcher = PREFIX_TEMPLATE.matcher(source2);
        if (!matcher.find()) {
            this.subject = new Subject(Optional.empty());
            this.predicate = new Predicate(source2);
            this.methodPrefix = null;
        } else {
            this.subject = new Subject(Optional.ofNullable(matcher.group(0)));
            this.methodPrefix = matcher.group(1);
            this.predicate = new Predicate(StringUtils.stripToEmpty((String)matcher.group(4)));
        }
    }

    public OrderBySource getOrderBySource() {
        return this.predicate.getOrderBySource();
    }

    public String getSubjectSource() {
        return this.subject.rawSource;
    }

    public String getPredicateSource() {
        return this.predicate.rawSource;
    }

    @Nullable
    public String getLimitPrefix() {
        return this.subject.limitPrefix;
    }

    @Nullable
    public String getMethodPrefix() {
        return this.methodPrefix;
    }

    public boolean isDistinct() {
        return this.subject.isDistinct();
    }

    public boolean isCountProjection() {
        return this.subject.isCountProjection();
    }

    public boolean isExistsProjection() {
        return this.subject.isExistsProjection();
    }

    public boolean isDelete() {
        return this.subject.isDelete();
    }

    public boolean isUpdate() {
        return this.subject.isUpdate();
    }

    public boolean isAllIgnoreCase() {
        return this.predicate.alwaysIgnoreCase;
    }

    public boolean isLimiting() {
        return this.getMaxResults() != null;
    }

    @Nullable
    public Integer getMaxResults() {
        return this.subject.getMaxResults();
    }

    public List<Part> getParts() {
        return StreamEx.of(this.getPredicateNodes()).flatMap(orPart -> orPart.children.stream()).toList();
    }

    public List<OrPart> getPredicateNodes() {
        return this.predicate.nodes;
    }

    public Iterable<Part> getParts(Part.Type type) {
        return StreamEx.of(this.getParts()).filter(part -> part.getType().equals((Object)type));
    }

    public boolean hasPredicate() {
        return !this.getPredicateNodes().isEmpty();
    }

    public String toString() {
        return String.format("%s %s", StreamEx.of(this.predicate.nodes).joining((CharSequence)" or "), this.predicate.getOrderBySource().toString()).trim();
    }

    private static String[] split(String text, String keyword) {
        Pattern pattern = Pattern.compile(String.format(KEYWORD_TEMPLATE, keyword));
        return pattern.split(text);
    }

    public static class Subject {
        public static final String DISTINCT = "Distinct";
        private static final Pattern COUNT_BY_TEMPLATE = Pattern.compile("^count(\\p{Lu}.*?)??(By(.*)|$)");
        private static final Pattern EXISTS_BY_TEMPLATE = Pattern.compile("^(exists)(\\p{Lu}.*?)??By");
        private static final Pattern DELETE_BY_TEMPLATE = Pattern.compile("^(delete|remove)(\\p{Lu}.*?)??By");
        private static final Pattern UPDATE_BY_TEMPLATE = Pattern.compile("^(update)(\\p{Lu}.*?)??By");
        private static final String LIMITING_QUERY_PATTERN = "(First|Top)(\\d*)?";
        public static final Pattern LIMITED_QUERY_TEMPLATE = Pattern.compile("^(find|read|get|query|search|stream)(Distinct)?(First|Top)(\\d*)?(\\p{Lu}.*?)??By");
        private final boolean distinct;
        private final boolean count;
        private final boolean exists;
        private final boolean delete;
        private final boolean update;
        private final String limitPrefix;
        private final Integer maxResults;
        private final String rawSource;

        public Subject(Optional<String> subject) {
            this.rawSource = subject.orElse(null);
            this.distinct = subject.map(it -> it.contains(DISTINCT)).orElse(false);
            this.count = Subject.matches(subject, COUNT_BY_TEMPLATE);
            this.exists = Subject.matches(subject, EXISTS_BY_TEMPLATE);
            this.delete = Subject.matches(subject, DELETE_BY_TEMPLATE);
            this.update = Subject.matches(subject, UPDATE_BY_TEMPLATE);
            Pair<String, Integer> maxResults = Subject.returnMaxResultsIfFirstKSubjectOrNull(subject);
            this.limitPrefix = maxResults == null ? null : (String)maxResults.first;
            this.maxResults = maxResults == null ? null : (Integer)maxResults.second;
        }

        @Nullable
        public String getRawSource() {
            return this.rawSource;
        }

        @Nullable
        private static Pair<String, Integer> returnMaxResultsIfFirstKSubjectOrNull(Optional<String> subject) {
            return subject.map(it -> {
                Matcher grp = LIMITED_QUERY_TEMPLATE.matcher((CharSequence)it);
                if (!grp.find()) {
                    return null;
                }
                int maxResult = !StringUtil.isEmptyOrSpaces((String)grp.group(4)) ? Integer.parseInt(grp.group(4)) : 1;
                return Pair.create((Object)grp.group(3), (Object)maxResult);
            }).orElse(null);
        }

        public boolean isDelete() {
            return this.delete;
        }

        public boolean isUpdate() {
            return this.update;
        }

        public boolean isCountProjection() {
            return this.count;
        }

        public boolean isExistsProjection() {
            return this.exists;
        }

        public boolean isDistinct() {
            return this.distinct;
        }

        public Integer getMaxResults() {
            return this.maxResults;
        }

        private static boolean matches(Optional<String> subject, Pattern pattern) {
            return subject.map(it -> pattern.matcher((CharSequence)it).find()).orElse(false);
        }
    }

    public static class Predicate {
        public static final Pattern ALL_IGNORE_CASE = Pattern.compile("AllIgnor(ing|e)Case");
        public static final String ORDER_BY = "OrderBy";
        private final List<OrPart> nodes;
        private final OrderBySource orderBySource;
        private boolean alwaysIgnoreCase;
        private final String rawSource;

        public Predicate(String predicate) {
            this.rawSource = predicate;
            String[] parts = PartTree.split(this.detectAndSetAllIgnoreCase(predicate), ORDER_BY);
            if (parts.length > 2) {
                throw new IllegalArgumentException("OrderBy must not be used more than once in a method name!");
            }
            this.nodes = Arrays.stream(PartTree.split(parts[0], "Or")).filter(s -> !StringUtil.isEmptyOrSpaces((String)s)).map(part -> new OrPart((String)part, this.alwaysIgnoreCase)).collect(Collectors.toList());
            try {
                this.orderBySource = parts.length == 2 ? new OrderBySource(parts[1]) : OrderBySource.EMPTY;
            }
            catch (IllegalArgumentException e) {
                throw new PropertyReferenceException(e.getMessage(), e);
            }
        }

        @Nullable
        public String getRawSource() {
            return this.rawSource;
        }

        private String detectAndSetAllIgnoreCase(String predicate) {
            Matcher matcher = ALL_IGNORE_CASE.matcher((CharSequence)predicate);
            if (matcher.find()) {
                this.alwaysIgnoreCase = true;
                predicate = ((String)predicate).substring(0, matcher.start()) + ((String)predicate).substring(matcher.end());
            }
            return predicate;
        }

        public OrderBySource getOrderBySource() {
            return this.orderBySource;
        }

        public List<OrPart> getNodes() {
            return this.nodes;
        }
    }

    public static class OrPart {
        private final List<Part> children;

        OrPart(String source2, boolean alwaysIgnoreCase) {
            String[] split = PartTree.split(source2, "And");
            this.children = Arrays.stream(split).filter(s -> !StringUtil.isEmptyOrSpaces((String)s)).map(part -> new Part((String)part, alwaysIgnoreCase)).collect(Collectors.toList());
        }

        public List<Part> getChildren() {
            return this.children;
        }

        public String toString() {
            return StreamEx.of(this.children).joining((CharSequence)" and ");
        }
    }
}

