/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.core.util;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.ProjectScope;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;
import org.jetbrains.jps.model.java.JavaResourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public final class JpbVfsUtil {
    @Nullable
    public static VirtualFile findRelativeFile(@Nullable VirtualFile base, @NotNull String path) {
        if (path == null) {
            JpbVfsUtil.$$$reportNull$$$0(0);
        }
        return VfsUtil.findRelativeFile((VirtualFile)base, (String[])path.replace('\\', '/').split("/"));
    }

    @Nullable
    public static String getRelativePathToSourceRoot(Project project, @NotNull VirtualFile file, @Nullable String defaultValue) {
        VirtualFile sourceRoot;
        if (file == null) {
            JpbVfsUtil.$$$reportNull$$$0(1);
        }
        if ((sourceRoot = JpbVfsUtil.findSourceRoot(file.getPath(), project, true)) != null) {
            String relativePath = VfsUtil.getRelativePath((VirtualFile)file, (VirtualFile)sourceRoot);
            return relativePath == null ? defaultValue : relativePath;
        }
        return defaultValue;
    }

    public static String readString(VirtualFile file) {
        try {
            return new String(VfsUtil.loadBytes((VirtualFile)file), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isProjectFile(PsiElement element) {
        return JpbVfsUtil.isProjectFile(element.getProject(), element.getOriginalElement().getContainingFile().getVirtualFile());
    }

    public static boolean isProjectFile(Project project, VirtualFile virtualFile) {
        return ProjectScope.getProjectScope((Project)project).accept(virtualFile);
    }

    @Nullable
    public static VirtualFile findSourceRoot(String childPath, Project project, boolean includeResource) {
        return StreamEx.of(JpbVfsUtil.getAllSourceRoots(project, includeResource)).findFirst(rootFile -> FileUtil.isAncestor((String)rootFile.getPath(), (String)childPath, (boolean)true) || FileUtil.pathsEqual((String)rootFile.getPath(), (String)childPath)).orElse(null);
    }

    public static List<VirtualFile> getAllSourceRoots(Project project, boolean includeResource) {
        HashSet rootTypes = new HashSet();
        if (includeResource) {
            rootTypes.add((JpsModuleSourceRootType<?>)JavaResourceRootType.RESOURCE);
        }
        rootTypes.addAll(JavaModuleSourceRootTypes.SOURCES);
        return JpbVfsUtil.getProjectSourceRoots(project, rootTypes);
    }

    public static List<VirtualFile> getProjectSourceRoots(Project project, @NotNull Set<JpsModuleSourceRootType<?>> rootTypes) {
        if (rootTypes == null) {
            JpbVfsUtil.$$$reportNull$$$0(2);
        }
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
        for (Module module : moduleManager.getModules()) {
            result.addAll(JpbVfsUtil.getModuleSourceRoots(module, rootTypes));
        }
        return result;
    }

    public static List<VirtualFile> getModuleSourceRoots(Module module, @NotNull Set<JpsModuleSourceRootType<?>> rootTypes) {
        if (rootTypes == null) {
            JpbVfsUtil.$$$reportNull$$$0(3);
        }
        return ModuleRootManager.getInstance((Module)module).getSourceRoots(rootTypes);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootTypes";
                break;
            }
        }
        objectArray2[1] = "com/intellij/jpa/jpb/model/core/util/JpbVfsUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findRelativeFile";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getRelativePathToSourceRoot";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getProjectSourceRoots";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getModuleSourceRoots";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

