/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.backend.ed;

import com.intellij.jpa.jpb.model.backend.ed.AppendAttributeInterceptor;
import com.intellij.jpa.jpb.model.backend.ed.annotation.AnnotationAppender;
import com.intellij.jpa.jpb.model.backend.ed.annotation.attr.JpaEntityAnnotation;
import com.intellij.jpa.jpb.model.config.JpaPluginProjectConfig;
import com.intellij.jpa.jpb.model.config.ProjectState;
import com.intellij.jpa.jpb.model.core.msg.JpaModelBundle;
import com.intellij.jpa.jpb.model.core.multilanguage.HLanguageService;
import com.intellij.jpa.jpb.model.core.multilanguage.LanguageServiceManager;
import com.intellij.jpa.jpb.model.model.Datatypes;
import com.intellij.jpa.jpb.model.model.DbIdentifierHelper;
import com.intellij.jpa.jpb.model.model.Entity;
import com.intellij.jpa.jpb.model.model.EntityAttribute;
import com.intellij.jpa.jpb.model.model.EntityAttributeModel;
import com.intellij.jpa.jpb.model.model.EntityPsi;
import com.intellij.jpa.jpb.model.model.SequenceGenerator;
import com.intellij.jpa.jpb.model.psibuilder.common.PsiMemberInsertionPlace;
import com.intellij.jpa.jpb.model.reference.TemplateHelper;
import com.intellij.jpa.jpb.model.util.PsiUtilsKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierListOwner;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface EntityWriter
extends HLanguageService {
    public static final String IDX_EDITOR_WRITE_ACTION_GROUP_ID = "Studio entity indexes editor's write action";
    public static final String PROPS_EDITOR_WRITE_ACTION_GROUP_ID = "Studio entity properties editor's write action";
    public static final Pattern COMMENT_ATTR_PATTERN = Pattern.compile("create field to map the\\s['\"](\\w+?)['\"]\\scolumn");
    public static final Datatypes.BasicDatatype OBJECT_BASIC_TYPE = Datatypes.BasicDatatype.createUnsafe("java.lang.Object");
    public static final String DB_VIEW_COMMENT = "Mapping for DB view";

    public static EntityWriter getInstance(PsiElement psiElement) {
        return LanguageServiceManager.getService(psiElement, EntityWriter.class);
    }

    public void commitEntityToPsi(Entity var1, PsiClass var2);

    public void commitEntityToPsiWithoutAttribute(@NotNull Entity var1, @NotNull PsiClass var2);

    public void addSerialVersionUID(PsiClass var1);

    public void addSerializableParentIfNeeded(@NotNull PsiClass var1);

    public List<String> getValidationAnnotationsText(Entity var1, EntityAttribute var2);

    public void addNewLinesIfNeed(@NotNull PsiField var1);

    public void commitAttributeToPsi(@NotNull EntityPsi var1, @NotNull EntityAttribute var2, @NotNull PsiMember var3);

    public void commitAttributeToPsi(@NotNull EntityPsi var1, @NotNull EntityAttribute var2, @NotNull PsiMember var3, boolean var4);

    @Nullable
    public PsiElement doAddAttribute(Entity var1, PsiClass var2, EntityAttribute var3, PsiMemberInsertionPlace var4);

    default public PsiElement doAddAttribute(Entity entity, PsiClass aClass, EntityAttribute attribute, int offsetPosition) {
        return this.doAddAttribute(entity, aClass, attribute, new PsiMemberInsertionPlace(offsetPosition, null, false));
    }

    public void setAnnotationValue(@NotNull PsiAnnotation var1, @NotNull String var2, @Nullable String var3, boolean var4);

    default public void addEntityListener(@NotNull PsiClass entityClass, @NotNull String classFqn) {
        AnnotationAppender annotationAppender;
        PsiAnnotation annotation;
        if (entityClass == null) {
            EntityWriter.$$$reportNull$$$0(0);
        }
        if (classFqn == null) {
            EntityWriter.$$$reportNull$$$0(1);
        }
        if ((annotation = PsiUtilsKt.findOrCreateJpbAnnotation((PsiModifierListOwner)entityClass, JpaEntityAnnotation.EntityListeners)) != null && (annotationAppender = (AnnotationAppender)AnnotationAppender.Companion.getInstance((PsiElement)entityClass)) != null) {
            annotationAppender.addClassExpressionAnnotationParameter(annotation, "value", classFqn);
        }
    }

    default public PsiElement addAttribute(Entity entity, PsiClass aClass, EntityAttribute attribute, int offsetPosition) {
        AppendAttributeInterceptor.INSTANCE.beforeAppend(aClass, attribute);
        return this.doAddAttribute(entity, aClass, attribute, offsetPosition);
    }

    public void pullUpExtendsList(PsiClass var1, PsiClass var2, PsiDirectory var3);

    public void setTableName(EntityPsi var1, String var2);

    public void setEntityName(EntityPsi var1, String var2);

    public void setIdClass(PsiClass var1, String var2);

    public void updateSequenceGeneratorAnnotation(SequenceGenerator var1, PsiClass var2, Module var3);

    public boolean isCommentedAttr(@NotNull PsiClass var1, @NotNull EntityAttributeModel var2);

    default public boolean isCommentedAttr(String commentText, @NotNull EntityAttributeModel attribute) {
        if (attribute == null) {
            EntityWriter.$$$reportNull$$$0(2);
        }
        if (!commentText.contains(JpaModelBundle.message("start.text.todo.reverse.engineering", new Object[0]))) {
            return false;
        }
        Matcher matcher = COMMENT_ATTR_PATTERN.matcher(commentText);
        if (!matcher.find()) {
            return false;
        }
        String columnName = matcher.group(1);
        return DbIdentifierHelper.compareIdentifier(columnName, attribute.getColumn());
    }

    default public String calculateCommentText(EntityAttribute attribute, String fieldSource) {
        Object commentText = JpaModelBundle.message("attribute.comment.text", attribute.getColumn() != null ? attribute.getColumn() : "null");
        commentText = (String)commentText + " ";
        String columnDefinition = attribute.getColumnDefinition();
        if (StringUtil.isNotEmpty((String)columnDefinition) && attribute.getType() == OBJECT_BASIC_TYPE) {
            commentText = (String)commentText + JpaModelBundle.message("defined.target.java.type", new Object[0]) + " | ";
        }
        commentText = (String)commentText + JpaModelBundle.message("uncomment.as.is", new Object[0]) + " | " + JpaModelBundle.message("remove.column.mapping", new Object[0]) + "\n";
        commentText = (String)commentText + "    " + StreamEx.of((Object[])StringUtil.splitByLines((String)fieldSource)).joining((CharSequence)"\n    ");
        commentText = (String)commentText + "\n*/";
        return commentText;
    }

    default public void addCommentJavaDoc(PsiElement owner, String comment) {
        if (comment != null && JpaPluginProjectConfig.getInstance((Project)owner.getProject()).getState().commentSavingStrategy == ProjectState.CommentSavingStrategy.JAVA_DOC) {
            String commentText = "/**\n * " + comment + "\n */";
            ((TemplateHelper)TemplateHelper.Companion.getInstance(owner)).addCommentToTop(owner, commentText, "");
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entityClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classFqn";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attribute";
                break;
            }
        }
        objectArray2[1] = "com/intellij/jpa/jpb/model/backend/ed/EntityWriter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addEntityListener";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isCommentedAttr";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

