/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.GridModelWithNestedTables;
import com.intellij.database.datagrid.GridPagingModel;
import com.intellij.database.datagrid.HierarchicalColumnsDataGridModel;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.MultiPageModel;
import com.intellij.database.datagrid.MultiPageModelImpl;
import com.intellij.database.datagrid.NestedTable;
import com.intellij.database.datagrid.NestedTablesDataGridModel;
import com.intellij.database.datagrid.StaticNestedTable;
import com.intellij.database.datagrid.nested.NestedTablesAware;
import java.util.ArrayList;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0011\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u00032\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0004:\u0001>B#\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0003\u00a2\u0006\u0004\b\t\u0010\nJ \u0010\u0011\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0096@\u00a2\u0006\u0002\u0010\u0016J\u0018\u0010\u0017\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0018\u001a\u00020\u0019H\u0096@\u00a2\u0006\u0002\u0010\u001aJ\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0015H\u0007J\u0010\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u0018\u001a\u00020\u0019H\u0007J\u0006\u0010\u001f\u001a\u00020\u001cJ\u001c\u0010 \u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00032\u0006\u0010\u001d\u001a\u00020\u0015H\u0002J\b\u0010!\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020\"H\u0016J\u0010\u0010$\u001a\u00020\u001c2\u0006\u0010%\u001a\u00020\u0019H\u0016J\b\u0010&\u001a\u00020\u0019H\u0016J\b\u0010'\u001a\u00020(H\u0016J\b\u0010)\u001a\u00020\"H\u0016J\b\u0010*\u001a\u00020\"H\u0016J\b\u0010+\u001a\u00020\u0019H\u0016J\b\u0010,\u001a\u00020\u0019H\u0016J\u0018\u0010-\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000.2\u0006\u0010/\u001a\u00020\u0019H\u0016J\b\u00100\u001a\u00020\"H\u0016J\u0010\u00101\u001a\u00020\u001c2\u0006\u00102\u001a\u00020\u0019H\u0016J\u0010\u00103\u001a\u00020\u001c2\u0006\u00104\u001a\u00020\u0019H\u0016J\u0018\u00105\u001a\u00020\u001c2\u0006\u00106\u001a\u00020(2\u0006\u00107\u001a\u00020\"H\u0016J\u0010\u00108\u001a\u00020\u001c2\u0006\u00109\u001a\u00020\"H\u0016J\u0010\u0010:\u001a\u00020\u001c2\u0006\u0010;\u001a\u00020\u0010H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00030\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010<\u001a\u00020\"8F\u00a2\u0006\u0006\u001a\u0004\b<\u0010=\u00a8\u0006?"}, d2={"Lcom/intellij/database/datagrid/NestedTableGridPagingModel;", "Row", "Column", "Lcom/intellij/database/datagrid/MultiPageModel;", "Lcom/intellij/database/datagrid/nested/NestedTablesAware;", "Ljava/lang/Void;", "myGridModel", "Lcom/intellij/database/datagrid/GridModelWithNestedTables;", "myTopLevelPagingModel", "<init>", "(Lcom/intellij/database/datagrid/GridModelWithNestedTables;Lcom/intellij/database/datagrid/MultiPageModel;)V", "myNestedTablePageModels", "Lcom/intellij/database/datagrid/nested/NestedTablesAware$NonEmptyStack;", "myCurrentPagingModel", "myListeners", "", "Lcom/intellij/database/datagrid/MultiPageModel$PageModelListener;", "enterNestedTable", "coordinate", "Lcom/intellij/database/datagrid/NestedTablesDataGridModel$NestedTableCellCoordinate;", "nestedTable", "Lcom/intellij/database/datagrid/NestedTable;", "(Lcom/intellij/database/datagrid/NestedTablesDataGridModel$NestedTableCellCoordinate;Lcom/intellij/database/datagrid/NestedTable;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "exitNestedTable", "steps", "", "(ILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "navigateIntoNestedTable", "", "newSelectedNestedTable", "navigateBackFromNestedTable", "reset", "createPageModel", "isFirstPage", "", "isLastPage", "setPageSize", "pageSize", "getPageSize", "getTotalRowCount", "", "isTotalRowCountPrecise", "isTotalRowCountUpdateable", "getPageStart", "getPageEnd", "findRow", "Lcom/intellij/database/datagrid/ModelIndex;", "rowNumber", "pageSizeSet", "setPageStart", "pageStart", "setPageEnd", "pageEnd", "setTotalRowCount", "totalRowCount", "precise", "setTotalRowCountUpdateable", "updateable", "addPageModelListener", "listener", "isStatic", "()Z", "StaticMultiPageModel", "intellij.grid.core.impl"})
public final class NestedTableGridPagingModel<Row, Column>
implements MultiPageModel<Row, Column>,
NestedTablesAware<Void> {
    @NotNull
    private final GridModelWithNestedTables myGridModel;
    @NotNull
    private final MultiPageModel<Row, Column> myTopLevelPagingModel;
    @NotNull
    private final NestedTablesAware.NonEmptyStack<MultiPageModel<Row, Column>> myNestedTablePageModels;
    @NotNull
    private MultiPageModel<Row, Column> myCurrentPagingModel;
    @NotNull
    private final List<MultiPageModel.PageModelListener> myListeners;

    public NestedTableGridPagingModel(@NotNull GridModelWithNestedTables myGridModel, @NotNull MultiPageModel<Row, Column> myTopLevelPagingModel) {
        Intrinsics.checkNotNullParameter((Object)myGridModel, (String)"myGridModel");
        Intrinsics.checkNotNullParameter(myTopLevelPagingModel, (String)"myTopLevelPagingModel");
        this.myGridModel = myGridModel;
        this.myTopLevelPagingModel = myTopLevelPagingModel;
        this.myNestedTablePageModels = new NestedTablesAware.NonEmptyStack<MultiPageModel<Row, Column>>(this.myTopLevelPagingModel);
        this.myCurrentPagingModel = this.myTopLevelPagingModel;
        this.myListeners = new ArrayList();
    }

    @Override
    @Nullable
    public Object enterNestedTable(@NotNull NestedTablesDataGridModel.NestedTableCellCoordinate coordinate, @NotNull NestedTable nestedTable, @NotNull Continuation<? super Void> $completion) {
        this.navigateIntoNestedTable(nestedTable);
        return null;
    }

    @Override
    @Nullable
    public Object exitNestedTable(int steps, @NotNull Continuation<? super Void> $completion) {
        this.navigateBackFromNestedTable(steps);
        return null;
    }

    @Deprecated(message="This method is deprecated and marked for removal. Use the {@link #enterNestedTable(NestedTableCellCoordinate, NestedTable)} method instead.")
    @ApiStatus.ScheduledForRemoval
    public final void navigateIntoNestedTable(@NotNull NestedTable newSelectedNestedTable) {
        Intrinsics.checkNotNullParameter((Object)newSelectedNestedTable, (String)"newSelectedNestedTable");
        this.myCurrentPagingModel = this.createPageModel(newSelectedNestedTable);
        this.myNestedTablePageModels.push(this.myCurrentPagingModel);
    }

    @Deprecated(message="This method is deprecated and marked for removal. Use the {@link #exitNestedTable(int)}} method instead.")
    @ApiStatus.ScheduledForRemoval
    public final void navigateBackFromNestedTable(int steps) {
        this.myNestedTablePageModels.pop(steps);
        this.myCurrentPagingModel = this.myNestedTablePageModels.last();
    }

    public final void reset() {
        this.myCurrentPagingModel = this.myTopLevelPagingModel;
        this.myNestedTablePageModels.reset(this.myTopLevelPagingModel);
    }

    private final MultiPageModel<Row, Column> createPageModel(NestedTable newSelectedNestedTable) {
        MultiPageModel multiPageModel;
        if (newSelectedNestedTable instanceof StaticNestedTable) {
            GridModelWithNestedTables gridModelWithNestedTables = this.myGridModel;
            Intrinsics.checkNotNull((Object)gridModelWithNestedTables, (String)"null cannot be cast to non-null type com.intellij.database.datagrid.GridModel<Row of com.intellij.database.datagrid.NestedTableGridPagingModel, Column of com.intellij.database.datagrid.NestedTableGridPagingModel>");
            multiPageModel = new StaticMultiPageModel((GridModel)((Object)gridModelWithNestedTables), this.myTopLevelPagingModel);
        } else {
            GridModelWithNestedTables gridModelWithNestedTables = this.myGridModel;
            Intrinsics.checkNotNull((Object)gridModelWithNestedTables, (String)"null cannot be cast to non-null type com.intellij.database.datagrid.GridModel<Row of com.intellij.database.datagrid.NestedTableGridPagingModel, Column of com.intellij.database.datagrid.NestedTableGridPagingModel>");
            multiPageModel = new MultiPageModelImpl((GridModel)((Object)gridModelWithNestedTables), null);
        }
        MultiPageModel model = multiPageModel;
        model.setPageSize(this.myTopLevelPagingModel.getPageSize());
        for (MultiPageModel.PageModelListener listener : this.myListeners) {
            model.addPageModelListener(listener);
        }
        return model;
    }

    @Override
    public boolean isFirstPage() {
        return this.myCurrentPagingModel.isFirstPage();
    }

    @Override
    public boolean isLastPage() {
        return this.myCurrentPagingModel.isLastPage();
    }

    @Override
    public void setPageSize(int pageSize) {
        this.myCurrentPagingModel.setPageSize(pageSize);
    }

    @Override
    public int getPageSize() {
        return this.myCurrentPagingModel.getPageSize();
    }

    @Override
    public long getTotalRowCount() {
        return this.myCurrentPagingModel.getTotalRowCount();
    }

    @Override
    public boolean isTotalRowCountPrecise() {
        return this.myCurrentPagingModel.isTotalRowCountPrecise();
    }

    @Override
    public boolean isTotalRowCountUpdateable() {
        return this.myCurrentPagingModel.isTotalRowCountUpdateable();
    }

    @Override
    public int getPageStart() {
        return this.myCurrentPagingModel.getPageStart();
    }

    @Override
    public int getPageEnd() {
        return this.myCurrentPagingModel.getPageEnd();
    }

    @Override
    @NotNull
    public ModelIndex<Row> findRow(int rowNumber) {
        ModelIndex modelIndex = this.myCurrentPagingModel.findRow(rowNumber);
        Intrinsics.checkNotNullExpressionValue(modelIndex, (String)"findRow(...)");
        return modelIndex;
    }

    @Override
    public boolean pageSizeSet() {
        return this.myCurrentPagingModel.pageSizeSet();
    }

    @Override
    public void setPageStart(int pageStart) {
        this.myCurrentPagingModel.setPageStart(pageStart);
    }

    @Override
    public void setPageEnd(int pageEnd) {
        this.myCurrentPagingModel.setPageEnd(pageEnd);
    }

    @Override
    public void setTotalRowCount(long totalRowCount, boolean precise) {
        this.myCurrentPagingModel.setTotalRowCount(totalRowCount, precise);
    }

    @Override
    public void setTotalRowCountUpdateable(boolean updateable) {
        this.myCurrentPagingModel.setTotalRowCountUpdateable(updateable);
    }

    @Override
    public void addPageModelListener(@NotNull MultiPageModel.PageModelListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.myListeners.add(listener);
        for (MultiPageModel<Row, Column> model : this.myNestedTablePageModels) {
            model.addPageModelListener(listener);
        }
    }

    public final boolean isStatic() {
        return this.myCurrentPagingModel instanceof StaticMultiPageModel;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\u0018\u0000*\u0004\b\u0002\u0010\u0001*\u0004\b\u0003\u0010\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0003B/\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\u000e\u001a\u00020\u000bH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u000bH\u0016J\b\u0010\u0017\u001a\u00020\u000bH\u0016J\b\u0010\u0018\u001a\u00020\u0012H\u0016J\b\u0010\u0019\u001a\u00020\u0012H\u0016J\u0018\u0010\u001a\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0012H\u0016J\b\u0010\u001d\u001a\u00020\u000bH\u0016J\u0010\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020\u0012H\u0016J\u0010\u0010 \u001a\u00020\u00102\u0006\u0010!\u001a\u00020\u0012H\u0016J\u0018\u0010\"\u001a\u00020\u00102\u0006\u0010#\u001a\u00020\u00152\u0006\u0010$\u001a\u00020\u000bH\u0016J\u0010\u0010%\u001a\u00020\u00102\u0006\u0010&\u001a\u00020\u000bH\u0016J\u0010\u0010'\u001a\u00020\u00102\u0006\u0010(\u001a\u00020)H\u0016R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006*"}, d2={"Lcom/intellij/database/datagrid/NestedTableGridPagingModel$StaticMultiPageModel;", "Row", "Column", "Lcom/intellij/database/datagrid/MultiPageModel;", "myGridModel", "Lcom/intellij/database/datagrid/GridModel;", "myDelegate", "Lcom/intellij/database/datagrid/GridPagingModel;", "<init>", "(Lcom/intellij/database/datagrid/GridModel;Lcom/intellij/database/datagrid/GridPagingModel;)V", "isFirstPage", "", "isNestedGrid", "()Z", "isLastPage", "setPageSize", "", "pageSize", "", "getPageSize", "getTotalRowCount", "", "isTotalRowCountPrecise", "isTotalRowCountUpdateable", "getPageStart", "getPageEnd", "findRow", "Lcom/intellij/database/datagrid/ModelIndex;", "rowNumber", "pageSizeSet", "setPageStart", "pageStart", "setPageEnd", "pageEnd", "setTotalRowCount", "totalRowCount", "precise", "setTotalRowCountUpdateable", "updateable", "addPageModelListener", "listener", "Lcom/intellij/database/datagrid/MultiPageModel$PageModelListener;", "intellij.grid.core.impl"})
    public static final class StaticMultiPageModel<Row, Column>
    implements MultiPageModel<Row, Column> {
        @NotNull
        private final GridModel<Row, Column> myGridModel;
        @NotNull
        private final GridPagingModel<Row, Column> myDelegate;

        public StaticMultiPageModel(@NotNull GridModel<Row, Column> myGridModel, @NotNull GridPagingModel<Row, Column> myDelegate) {
            Intrinsics.checkNotNullParameter(myGridModel, (String)"myGridModel");
            Intrinsics.checkNotNullParameter(myDelegate, (String)"myDelegate");
            this.myGridModel = myGridModel;
            this.myDelegate = myDelegate;
        }

        @Override
        public boolean isFirstPage() {
            return this.isNestedGrid() || this.myDelegate.isFirstPage();
        }

        private final boolean isNestedGrid() {
            return this.myGridModel instanceof HierarchicalColumnsDataGridModel && !((HierarchicalColumnsDataGridModel)this.myGridModel).isTopLevelGrid();
        }

        @Override
        public boolean isLastPage() {
            return this.isNestedGrid() || this.myDelegate.isLastPage();
        }

        @Override
        public void setPageSize(int pageSize) {
            if (!this.isNestedGrid()) {
                this.myDelegate.setPageSize(pageSize);
            }
        }

        @Override
        public int getPageSize() {
            return this.isNestedGrid() ? this.myGridModel.getRowCount() : this.myDelegate.getPageSize();
        }

        @Override
        public long getTotalRowCount() {
            return this.isNestedGrid() ? (long)this.myGridModel.getRowCount() : this.myDelegate.getTotalRowCount();
        }

        @Override
        public boolean isTotalRowCountPrecise() {
            return this.isNestedGrid() || this.myDelegate.isTotalRowCountPrecise();
        }

        @Override
        public boolean isTotalRowCountUpdateable() {
            return this.isNestedGrid() || this.myDelegate.isTotalRowCountUpdateable();
        }

        @Override
        public int getPageStart() {
            return this.isNestedGrid() ? 1 : this.myDelegate.getPageStart();
        }

        @Override
        public int getPageEnd() {
            return this.isNestedGrid() ? this.myGridModel.getRowCount() : this.myDelegate.getPageEnd();
        }

        @Override
        @NotNull
        public ModelIndex<Row> findRow(int rowNumber) {
            ModelIndex<Row> modelIndex;
            if (this.isNestedGrid()) {
                ModelIndex<Row> modelIndex2 = ModelIndex.forRow(this.myGridModel, rowNumber - 1);
                modelIndex = modelIndex2;
                Intrinsics.checkNotNullExpressionValue(modelIndex2, (String)"forRow(...)");
            } else {
                ModelIndex<Row> modelIndex3 = this.myDelegate.findRow(rowNumber);
                modelIndex = modelIndex3;
                Intrinsics.checkNotNullExpressionValue(modelIndex3, (String)"findRow(...)");
            }
            return modelIndex;
        }

        @Override
        public boolean pageSizeSet() {
            return this.isNestedGrid() || this.myDelegate.pageSizeSet();
        }

        @Override
        public void setPageStart(int pageStart) {
        }

        @Override
        public void setPageEnd(int pageEnd) {
        }

        @Override
        public void setTotalRowCount(long totalRowCount, boolean precise) {
        }

        @Override
        public void setTotalRowCountUpdateable(boolean updateable) {
        }

        @Override
        public void addPageModelListener(@NotNull MultiPageModel.PageModelListener listener) {
            Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        }
    }
}

