/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.attributes;

import com.github.weisj.jsvg.attributes.paint.PaintParser;
import com.github.weisj.jsvg.attributes.paint.SVGPaint;
import com.github.weisj.jsvg.ax;
import com.github.weisj.jsvg.c;
import com.github.weisj.jsvg.dk;
import com.github.weisj.jsvg.geometry.size.Length;
import com.github.weisj.jsvg.geometry.size.Unit;
import com.github.weisj.jsvg.parser.AttributeNode;
import com.github.weisj.jsvg.parser.SeparatorMode;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AttributeParser {
    @NotNull
    private final PaintParser a;
    private static final Pattern b = Pattern.compile("\\s");
    private static final Pattern c = Pattern.compile("\\w+\\([^)]*\\)");

    /*
     * WARNING - void declaration
     */
    public AttributeParser(@NotNull PaintParser paintParser) {
        void var1_1;
        this.a = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Contract(value="_,!null -> !null")
    @Nullable
    public final Length parseLength(@Nullable String value, @Nullable Length fallback) {
        String string;
        if (value == null) {
            return fallback;
        }
        Unit unit = Unit.Raw;
        string = string.toLowerCase(Locale.ENGLISH);
        for (Unit unit2 : Unit.units()) {
            if (!string.endsWith(unit2.suffix())) continue;
            unit = unit2;
            break;
        }
        String string2 = string.substring(0, string.length() - unit.suffix().length());
        try {
            return unit.valueOf(Float.parseFloat(string2));
        }
        catch (NumberFormatException numberFormatException) {
            void var2_2;
            return var2_2;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final float parsePercentage(@Nullable String value, float fallback) {
        void var2_2;
        void var1_1;
        return this.parsePercentage((String)var1_1, (float)var2_2, 0.0f, 1.0f);
    }

    /*
     * WARNING - void declaration
     */
    public final float parsePercentage(@Nullable String value, float fallback, float min, float max) {
        if (value == null) {
            return fallback;
        }
        try {
            void var3_4;
            void var1_1;
            float f2 = value.endsWith("%") ? Float.parseFloat(value.substring(0, var1_1.length() - 1)) / 100.0f : Float.parseFloat((String)var1_1);
            return Math.max((float)var3_4, Math.min(max, f2));
        }
        catch (NumberFormatException numberFormatException) {
            void var2_3;
            return (float)var2_3;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final int parseInt(@Nullable String value, int fallback) {
        if (value == null) {
            return fallback;
        }
        try {
            void var1_1;
            return Integer.parseInt((String)var1_1);
        }
        catch (NumberFormatException numberFormatException) {
            void var2_2;
            return (int)var2_2;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final float parseFloat(@Nullable String value, float fallback) {
        if (value == null) {
            return fallback;
        }
        try {
            void var1_1;
            return Float.parseFloat((String)var1_1);
        }
        catch (NumberFormatException numberFormatException) {
            void var2_2;
            return (float)var2_2;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final float parseAngle(@Nullable String value, float fallback) {
        String string;
        if (value == null) {
            return fallback;
        }
        ax ax2 = ax.Raw;
        string = string.toLowerCase(Locale.ENGLISH);
        for (ax ax3 : ax.units()) {
            if (!string.endsWith(ax3.suffix())) continue;
            ax2 = ax3;
            break;
        }
        String string2 = string.substring(0, string.length() - ax2.suffix().length());
        try {
            return ax2.toRadians(Float.parseFloat(string2), ax.Deg);
        }
        catch (NumberFormatException numberFormatException) {
            void var2_2;
            return (float)var2_2;
        }
    }

    public final Length[] parseLengthList(@Nullable String value) {
        List<String> list;
        if (value != null && value.equalsIgnoreCase("none")) {
            return new Length[0];
        }
        list = this.parseStringList((String)((Object)list), SeparatorMode.COMMA_AND_WHITESPACE);
        Length[] lengthArray = new Length[list.size()];
        for (int i2 = 0; i2 < lengthArray.length; ++i2) {
            Length length = this.parseLength(list.get(i2), null);
            if (length == null) {
                return new Length[0];
            }
            lengthArray[i2] = length;
        }
        return lengthArray;
    }

    public final float[] parseFloatList(@Nullable String value) {
        List<String> list;
        list = this.parseStringList((String)((Object)list), SeparatorMode.COMMA_AND_WHITESPACE);
        float[] fArray = new float[list.size()];
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            fArray[i2] = this.parseFloat(list.get(i2), 0.0f);
        }
        return fArray;
    }

    public final double[] parseDoubleList(@Nullable String value) {
        dk dk2;
        if (value == null || value.isEmpty()) {
            return new double[0];
        }
        ArrayList<Double> arrayList = new ArrayList<Double>();
        dk2 = new dk((String)((Object)dk2));
        while (dk2.f()) {
            arrayList.add(dk2.i());
            dk2.g();
        }
        return arrayList.stream().mapToDouble(Double::doubleValue).toArray();
    }

    /*
     * WARNING - void declaration
     */
    public final List<String> parseStringList(@Nullable String value, SeparatorMode separatorMode) {
        int n2;
        if (value == null || value.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        int n3 = value.length();
        int n4 = 0;
        boolean bl2 = false;
        for (n2 = 0; n2 < n3; ++n2) {
            char c2 = value.charAt(n2);
            if (Character.isWhitespace(c2)) {
                if (!bl2 && separatorMode != SeparatorMode.COMMA_ONLY && n2 - n4 > 0) {
                    arrayList.add(value.substring(n4, n2));
                    n4 = n2 + 1;
                }
                bl2 = true;
                continue;
            }
            bl2 = false;
            if (c2 != ',' || separatorMode == SeparatorMode.WHITESPACE_ONLY) continue;
            arrayList.add(value.substring(n4, n2));
            n4 = n2 + 1;
        }
        if (n2 - n4 > 0) {
            void var1_1;
            arrayList.add(var1_1.substring(n4, n2));
        }
        return arrayList;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final SVGPaint parsePaint(@Nullable String value, @NotNull AttributeNode attributeNode) {
        void var2_2;
        void var1_1;
        return this.a.parsePaint((String)var1_1, (AttributeNode)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <E extends Enum<E>> E parseEnum(@Nullable String value, @NotNull E fallback) {
        E e2;
        if ((e2 = this.parseEnum((String)e2, fallback.getDeclaringClass())) == null) {
            void var2_2;
            return var2_2;
        }
        return e2;
    }

    @Nullable
    public final <E extends Enum<E>> E parseEnum(@Nullable String value, @NotNull Class<E> enumType) {
        Enum[] enumArray;
        if (value == null) {
            return null;
        }
        for (Enum enum_ : (Enum[])enumArray.getEnumConstants()) {
            if (!(enum_ instanceof c ? ((c)((Object)enum_)).matchName() : enum_.name()).equalsIgnoreCase(value)) continue;
            return (E)enum_;
        }
        return null;
    }

    @NotNull
    private static String a(@NotNull String string) {
        return b.matcher(string).replaceAll("");
    }

    @Nullable
    public static String parseUrl(@Nullable String value) {
        String string;
        if (value == null) {
            return null;
        }
        if (!value.startsWith("url(") || !value.endsWith(")")) {
            return AttributeParser.a(value);
        }
        return AttributeParser.a(value.substring(4, string.length() - 1));
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final AffineTransform parseTransform(@Nullable String value) {
        if (value == null) {
            return null;
        }
        Matcher matcher = c.matcher(value);
        AffineTransform affineTransform = new AffineTransform();
        block26: while (matcher.find()) {
            String string = matcher.group();
            try {
                AffineTransform affineTransform2 = affineTransform;
                String string2 = string;
                Object object = this;
                int n2 = string2.indexOf(40);
                int n3 = string2.lastIndexOf(41);
                String string3 = string2.substring(0, string2.indexOf(40)).toLowerCase(Locale.ENGLISH);
                object = ((AttributeParser)object).parseDoubleList(string2.substring(n2 + 1, n3));
                switch (string3) {
                    case "matrix": {
                        affineTransform2.concatenate(new AffineTransform((double[])object));
                        continue block26;
                    }
                    case "translate": {
                        if (((Object)object).length == 1) {
                            affineTransform2.translate((double)object[0], 0.0);
                            continue block26;
                        }
                        affineTransform2.translate((double)object[0], (double)object[1]);
                        continue block26;
                    }
                    case "translatex": {
                        affineTransform2.translate((double)object[0], 0.0);
                        continue block26;
                    }
                    case "translatey": {
                        affineTransform2.translate(0.0, (double)object[0]);
                        continue block26;
                    }
                    case "scale": {
                        if (((Object)object).length == 1) {
                            affineTransform2.scale((double)object[0], (double)object[0]);
                            continue block26;
                        }
                        affineTransform2.scale((double)object[0], (double)object[1]);
                        continue block26;
                    }
                    case "scalex": {
                        affineTransform2.scale((double)object[0], 1.0);
                        continue block26;
                    }
                    case "scaley": {
                        affineTransform2.scale(1.0, (double)object[0]);
                        continue block26;
                    }
                    case "rotate": {
                        if (((Object)object).length > 2) {
                            affineTransform2.rotate(Math.toRadians((double)object[0]), (double)object[1], (double)object[2]);
                            continue block26;
                        }
                        affineTransform2.rotate(Math.toRadians((double)object[0]));
                        continue block26;
                    }
                    case "skewx": {
                        affineTransform2.shear(Math.tan(Math.toRadians((double)object[0])), 0.0);
                        continue block26;
                    }
                    case "skewy": {
                        affineTransform2.shear(0.0, Math.tan(Math.toRadians((double)object[0])));
                        continue block26;
                    }
                }
                throw new IllegalArgumentException("Unknown transform type: " + string3);
            }
            catch (Exception exception) {
                void var1_1;
                throw new IllegalArgumentException("Illegal transform definition '" + (String)var1_1 + "' encountered error while parsing '" + string + "'", exception);
            }
        }
        return affineTransform;
    }

    @NotNull
    public final PaintParser paintParser() {
        return this.a;
    }
}

