/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.usages;

import com.intellij.navigation.NavigationItem;
import com.intellij.navigation.NavigationItemFileStatus;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.SpringApiBundle;
import com.intellij.spring.SpringPresentationProvider;
import com.intellij.spring.dom.SpringDomUtils;
import com.intellij.spring.model.xml.DomSpringBean;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageGroup;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageView;
import com.intellij.usages.rules.PsiElementUsage;
import com.intellij.usages.rules.SingleParentUsageGroupingRule;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SpringBeansGroupingRule
extends SingleParentUsageGroupingRule {
    private static final Logger LOG = Logger.getInstance(SpringBeansGroupingRule.class);

    @Nullable
    protected UsageGroup getParentGroupFor(@NotNull Usage usage, UsageTarget @NotNull [] targets) {
        DomSpringBean springBean;
        DomElement domElement;
        PsiElement psiElement;
        PsiFile psiFile;
        if (usage == null) {
            SpringBeansGroupingRule.$$$reportNull$$$0(0);
        }
        if (targets == null) {
            SpringBeansGroupingRule.$$$reportNull$$$0(1);
        }
        if (usage instanceof PsiElementUsage && (psiFile = (psiElement = ((PsiElementUsage)usage).getElement()).getContainingFile()) instanceof XmlFile && SpringDomUtils.isSpringXml((XmlFile)((XmlFile)psiFile)) && (domElement = DomUtil.getDomElement((PsiElement)psiElement)) != null && (springBean = (DomSpringBean)domElement.getParentOfType(DomSpringBean.class, false)) != null) {
            return new SpringBeansUsageGroup(springBean);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "usage";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "targets";
                break;
            }
        }
        objectArray[1] = "com/intellij/spring/usages/SpringBeansGroupingRule";
        objectArray[2] = "getParentGroupFor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class SpringBeansUsageGroup
    implements UsageGroup,
    UiDataProvider {
        @NlsSafe
        private final String myName;
        private final DomSpringBean myBean;

        SpringBeansUsageGroup(@NotNull DomSpringBean bean) {
            if (bean == null) {
                SpringBeansUsageGroup.$$$reportNull$$$0(0);
            }
            this.myBean = bean;
            String beanName = bean.getPresentation().getElementName();
            this.myName = beanName == null ? SpringApiBundle.message((String)"spring.bean.with.unknown.name", (Object[])new Object[0]) : beanName;
            this.update();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SpringBeansUsageGroup that = (SpringBeansUsageGroup)o;
            if (!this.myName.equals(that.myName)) {
                return false;
            }
            if (!this.isValid()) {
                return false;
            }
            if (!that.isValid()) {
                return false;
            }
            return this.myBean.equals((Object)that.myBean);
        }

        public int hashCode() {
            int result2 = this.myName.hashCode();
            result2 = 31 * result2 + this.myBean.hashCode();
            return result2;
        }

        public Icon getIcon() {
            return this.isValid() ? SpringPresentationProvider.getSpringIcon((Object)this.myBean) : null;
        }

        @NotNull
        public String getPresentableGroupText() {
            String string = this.myName;
            if (string == null) {
                SpringBeansUsageGroup.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NotNull
        public DomSpringBean getBean() {
            DomSpringBean domSpringBean = this.myBean;
            if (domSpringBean == null) {
                SpringBeansUsageGroup.$$$reportNull$$$0(2);
            }
            return domSpringBean;
        }

        public FileStatus getFileStatus() {
            return this.isValid() ? NavigationItemFileStatus.get((NavigationItem)DomUtil.getFile((DomElement)this.getBean())) : null;
        }

        public boolean isValid() {
            return this.getBean().isValid();
        }

        public void navigate(boolean focus) throws UnsupportedOperationException {
            if (this.canNavigate()) {
                SpringDomUtils.navigate((DomElement)this.myBean);
            }
        }

        public boolean canNavigate() {
            return this.isValid();
        }

        public boolean canNavigateToSource() {
            return this.canNavigate();
        }

        public int compareTo(@NotNull UsageGroup usageGroup) {
            if (usageGroup == null) {
                SpringBeansUsageGroup.$$$reportNull$$$0(3);
            }
            if (!(usageGroup instanceof SpringBeansUsageGroup)) {
                LOG.error("SpringBeansUsageGroup expected but " + String.valueOf(usageGroup.getClass()) + " found");
                return 0;
            }
            return this.myName.compareToIgnoreCase(((SpringBeansUsageGroup)usageGroup).myName);
        }

        public void uiDataSnapshot(@NotNull DataSink sink) {
            if (sink == null) {
                SpringBeansUsageGroup.$$$reportNull$$$0(4);
            }
            sink.lazy(CommonDataKeys.PSI_ELEMENT, () -> {
                XmlElement element = this.isValid() ? this.getPsiElement() : null;
                return element != null && element.isValid() ? element : null;
            });
            sink.lazy(UsageView.USAGE_INFO_KEY, () -> {
                XmlElement element = this.isValid() ? this.getPsiElement() : null;
                return element != null && element.isValid() ? new UsageInfo((PsiElement)element) : null;
            });
        }

        @Nullable
        private XmlElement getPsiElement() {
            return this.getBean().getXmlElement();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "bean";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/spring/usages/SpringBeansGroupingRule$SpringBeansUsageGroup";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "usageGroup";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sink";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/spring/usages/SpringBeansGroupingRule$SpringBeansUsageGroup";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentableGroupText";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getBean";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "compareTo";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "uiDataSnapshot";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }
    }
}

