/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.module.components;

import com.intellij.facet.Facet;
import com.intellij.facet.pointers.FacetPointer;
import com.intellij.facet.pointers.FacetPointersManager;
import com.intellij.ide.presentation.Presentation;
import com.intellij.ide.presentation.PresentationProvider;
import com.intellij.javaee.module.components.FrameworkVirtualFileSystem;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtilRt;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Presentation(provider=MyPresentationProvider.class)
public abstract class FrameworkElementAsVirtualFileImpl<T extends Facet<?>>
extends VirtualFile {
    private final String myProjectId;
    private final FacetPointer<T> myFacetPointer;
    private String myElementName;
    protected final String myElementType;

    protected FrameworkElementAsVirtualFileImpl(@NotNull FacetPointer<T> facetPointer, String elementType, String elementName) {
        if (facetPointer == null) {
            FrameworkElementAsVirtualFileImpl.$$$reportNull$$$0(0);
        }
        this.myProjectId = facetPointer.getProject().getLocationHash();
        this.myElementType = elementType;
        this.myFacetPointer = facetPointer;
        this.myElementName = elementName;
    }

    @NotNull
    public abstract String getPresentableName();

    @NotNull
    public FacetPointer<T> getFacetPointer() {
        FacetPointer<T> facetPointer = this.myFacetPointer;
        if (facetPointer == null) {
            FrameworkElementAsVirtualFileImpl.$$$reportNull$$$0(1);
        }
        return facetPointer;
    }

    @NotNull
    public String getPath() {
        String string = FrameworkElementAsVirtualFileImpl.getPath(this.myFacetPointer, this.myElementType, this.myElementName);
        if (string == null) {
            FrameworkElementAsVirtualFileImpl.$$$reportNull$$$0(2);
        }
        return string;
    }

    public static String getPath(Facet facet, String elementType, String elementName) {
        return FrameworkVirtualFileSystem.getPath(facet.getModule().getProject(), FacetPointersManager.constructId((Facet)facet), elementType, elementName);
    }

    public static String getPath(@NotNull FacetPointer<? extends Facet> facetPointer, String elementType, String elementName) {
        if (facetPointer == null) {
            FrameworkElementAsVirtualFileImpl.$$$reportNull$$$0(3);
        }
        return FrameworkVirtualFileSystem.getPath(facetPointer, elementType, elementName);
    }

    public String getElementName() {
        return this.myElementName;
    }

    public String getModuleName() {
        return this.myFacetPointer.getModuleName();
    }

    public String getFacetName() {
        return this.myFacetPointer.getFacetName();
    }

    @Nullable
    public T findFacet() {
        return (T)this.myFacetPointer.getFacet();
    }

    @NotNull
    public FrameworkVirtualFileSystem getFileSystem() {
        FrameworkVirtualFileSystem frameworkVirtualFileSystem = FrameworkVirtualFileSystem.getJ2EEInstance();
        if (frameworkVirtualFileSystem == null) {
            FrameworkElementAsVirtualFileImpl.$$$reportNull$$$0(4);
        }
        return frameworkVirtualFileSystem;
    }

    public void setElementName(String elementName) {
        this.myElementName = elementName;
    }

    public boolean isWritable() {
        return true;
    }

    public boolean isDirectory() {
        return false;
    }

    public VirtualFile getParent() {
        return null;
    }

    public VirtualFile[] getChildren() {
        return EMPTY_ARRAY;
    }

    @NotNull
    public InputStream getInputStream() throws IOException {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public OutputStream getOutputStream(Object requestor, long newModificationStamp, long newTimeStamp) throws IOException {
        throw new UnsupportedOperationException();
    }

    public byte @NotNull [] contentsToByteArray() throws IOException {
        if (ArrayUtilRt.EMPTY_BYTE_ARRAY == null) {
            FrameworkElementAsVirtualFileImpl.$$$reportNull$$$0(5);
        }
        return ArrayUtilRt.EMPTY_BYTE_ARRAY;
    }

    public long getModificationStamp() {
        return 0L;
    }

    public long getTimeStamp() {
        return 0L;
    }

    public long getLength() {
        return 0L;
    }

    public void refresh(boolean asynchronous, boolean recursive, Runnable postRunnable) {
    }

    @NotNull
    public String getName() {
        String string = this.getElementName();
        if (string == null) {
            FrameworkElementAsVirtualFileImpl.$$$reportNull$$$0(6);
        }
        return string;
    }

    public boolean isValid() {
        Project project = this.getFileSystem().getProject(this.myProjectId);
        return project != null && !project.isDisposed();
    }

    protected abstract Icon getIcon();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 4, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facetPointer";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javaee/module/components/FrameworkElementAsVirtualFileImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javaee/module/components/FrameworkElementAsVirtualFileImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFacetPointer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileSystem";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "contentsToByteArray";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getPath";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 4, 5, 6 -> new IllegalStateException(string);
        };
    }

    public static class MyPresentationProvider
    extends PresentationProvider<FrameworkElementAsVirtualFileImpl> {
        public Icon getIcon(FrameworkElementAsVirtualFileImpl o) {
            return o.getIcon();
        }
    }
}

